/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.util.function.Function;

@FunctionalInterface
public interface HandlerInterceptor {
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> var1, Handler<DeserializingMessage> var2, String var3);

    default public HandlerInterceptor merge(HandlerInterceptor nextInterceptor) {
        return (f, h, c) -> this.interceptHandling(nextInterceptor.interceptHandling(f, (Handler<DeserializingMessage>)h, c), (Handler<DeserializingMessage>)h, c);
    }

    default public Handler<DeserializingMessage> wrap(Handler<DeserializingMessage> handler, String consumer) {
        return new InterceptedHandler(this, handler, consumer);
    }

    public static class InterceptedHandler
    implements Handler<DeserializingMessage> {
        private final HandlerInterceptor interceptor;
        private final Handler<DeserializingMessage> delegate;
        private final String consumer;

        public Object invoke(DeserializingMessage message) {
            return this.interceptor.interceptHandling(arg_0 -> this.delegate.invoke(arg_0), this.delegate, this.consumer).apply(message);
        }

        public boolean canHandle(DeserializingMessage message) {
            return this.delegate.canHandle((Object)message);
        }

        public Executable getMethod(DeserializingMessage message) {
            return this.delegate.getMethod((Object)message);
        }

        public Object getTarget() {
            return this.delegate.getTarget();
        }

        @ConstructorProperties(value={"interceptor", "delegate", "consumer"})
        public InterceptedHandler(HandlerInterceptor interceptor, Handler<DeserializingMessage> delegate, String consumer) {
            this.interceptor = interceptor;
            this.delegate = delegate;
            this.consumer = consumer;
        }
    }
}

