/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.serialization.Revision;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcaster;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerializer
implements Serializer {
    private static final Logger log = LoggerFactory.getLogger(AbstractSerializer.class);
    private final Upcaster<SerializedObject<byte[], ?>> upcasterChain;
    private final String format;

    protected AbstractSerializer(Upcaster<SerializedObject<byte[], ?>> upcasterChain, String format) {
        this.upcasterChain = upcasterChain;
        this.format = format;
    }

    @Override
    public Data<byte[]> serialize(Object object) {
        byte[] bytes;
        try {
            if (object instanceof Data) {
                Data data = (Data)object;
                if (data.getValue() instanceof byte[]) {
                    return data;
                }
                return new Data((Object)((byte[])this.serialize(data.getValue()).getValue()), data.getType(), data.getRevision(), this.format);
            }
            bytes = this.doSerialize(object);
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize " + object, e);
        }
        Revision revision = this.getRevision(object);
        Type type = this.getType(object);
        return new Data((Object)bytes, this.asString(type), revision == null ? 0 : revision.value(), this.format);
    }

    protected Type getType(Object object) {
        Set values;
        Map map;
        Set keys;
        if (object == null) {
            return Void.class;
        }
        Class<?> type = object.getClass();
        if (Collection.class.isAssignableFrom(type)) {
            Collection collection = (Collection)object;
            Set children = collection.stream().map(this::getType).collect(Collectors.toSet());
            if (children.size() == 1) {
                return TypeUtils.parameterize(type, (Type[])new Type[]{(Type)children.iterator().next()});
            }
        } else if (Map.class.isAssignableFrom(type) && (keys = (map = (Map)object).keySet().stream().map(this::getType).collect(Collectors.toSet())).size() == 1 && (values = map.values().stream().map(this::getType).collect(Collectors.toSet())).size() == 1) {
            return TypeUtils.parameterize(type, (Type[])new Type[]{(Type)keys.iterator().next(), (Type)values.iterator().next()});
        }
        return type;
    }

    protected String asString(Type type) {
        return type.getTypeName();
    }

    protected Revision getRevision(Object object) {
        return object == null ? null : object.getClass().getAnnotation(Revision.class);
    }

    protected abstract byte[] doSerialize(Object var1) throws Exception;

    public <S extends SerializedObject<byte[], S>> Stream<DeserializingObject<byte[], S>> deserialize(Stream<S> dataStream, boolean failOnUnknownType) {
        return this.upcasterChain.upcast(dataStream).flatMap(s -> {
            if (!this.isKnownType(s.data().getType())) {
                if (failOnUnknownType) {
                    throw new SerializationException(String.format("Could not deserialize object. The serialized type is unknown: %s (rev. %d)", s.data().getType(), s.data().getRevision()));
                }
                return this.handleUnknownType((SerializedObject<byte[], ?>)s);
            }
            return Stream.of(new DeserializingObject((SerializedObject)s, type -> {
                try {
                    return Object.class.equals(type) ? this.doDeserialize((byte[])s.data().getValue(), s.data().getType()) : this.doDeserialize((byte[])s.data().getValue(), this.asString((Type)type));
                }
                catch (Exception e) {
                    throw new SerializationException("Could not deserialize a " + s.data().getType(), e);
                }
            }));
        });
    }

    @Override
    public <V> V convert(Object value, Class<V> type) {
        if (type == null || Object.class.equals(type)) {
            return (V)value;
        }
        return this.doConvert(value, type);
    }

    protected abstract <V> V doConvert(Object var1, Class<V> var2);

    protected boolean isKnownType(String type) {
        try {
            Class.forName(type);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Stream<DeserializingObject<byte[], ?>> handleUnknownType(SerializedObject<byte[], ?> serializedObject) {
        return Stream.empty();
    }

    protected abstract Object doDeserialize(byte[] var1, String var2) throws Exception;

    protected static enum NullValue {
        INSTANCE;

    }
}

