/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Serializer {
    public Data<byte[]> serialize(Object var1);

    default public <T> T deserialize(Data<byte[]> data) {
        List list = this.deserialize(Stream.of(data), true).map(d -> d.getPayload()).collect(Collectors.toList());
        if (list.size() != 1) {
            throw new SerializationException(String.format("Invalid deserialization result for a '%s'. Expected a single object but got %s", data, list));
        }
        return list.get(0);
    }

    public <I extends SerializedObject<byte[], I>> Stream<DeserializingObject<byte[], I>> deserialize(Stream<I> var1, boolean var2);

    default public Stream<DeserializingMessage> deserializeMessages(Stream<SerializedMessage> dataStream, boolean failOnUnknownType, MessageType messageType) {
        return this.deserialize(dataStream, failOnUnknownType).map(s -> new DeserializingMessage((DeserializingObject<byte[], SerializedMessage>)s, messageType));
    }

    public <V> V convert(Object var1, Class<V> var2);
}

