/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.util.Arrays;
import java.util.function.Function;

public abstract class AbstractClient
implements Client {
    private final String name;
    private final String id;
    private final ObjectUtils.MemoizingFunction<MessageType, ? extends GatewayClient> gatewayClients;
    private final ObjectUtils.MemoizingFunction<MessageType, ? extends TrackingClient> trackingClients;
    private final EventStoreClient eventStoreClient;
    private final SchedulingClient schedulingClient;
    private final KeyValueClient keyValueClient;
    private final SearchClient searchClient;

    public AbstractClient(String name, String id, Function<MessageType, ? extends GatewayClient> gatewayClients, Function<MessageType, ? extends TrackingClient> trackingClients, EventStoreClient eventStoreClient, SchedulingClient schedulingClient, KeyValueClient keyValueClient, SearchClient searchClient) {
        this.name = name;
        this.id = id;
        this.gatewayClients = ObjectUtils.memoize(gatewayClients);
        this.trackingClients = ObjectUtils.memoize(trackingClients);
        this.eventStoreClient = eventStoreClient;
        this.schedulingClient = schedulingClient;
        this.keyValueClient = keyValueClient;
        this.searchClient = searchClient;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public GatewayClient getGatewayClient(MessageType messageType) {
        return (GatewayClient)this.gatewayClients.apply((Object)messageType);
    }

    @Override
    public TrackingClient getTrackingClient(MessageType messageType) {
        return (TrackingClient)this.trackingClients.apply((Object)messageType);
    }

    @Override
    public void shutDown() {
        MessageType[] types = MessageType.values();
        Arrays.stream(types).filter(arg_0 -> this.trackingClients.isCached(arg_0)).map(this.trackingClients).forEach(TrackingClient::close);
        Arrays.stream(types).filter(arg_0 -> this.gatewayClients.isCached(arg_0)).map(this.gatewayClients).forEach(GatewayClient::close);
        this.eventStoreClient.close();
        this.schedulingClient.close();
        this.keyValueClient.close();
        this.searchClient.close();
    }

    @Override
    public EventStoreClient getEventStoreClient() {
        return this.eventStoreClient;
    }

    @Override
    public SchedulingClient getSchedulingClient() {
        return this.schedulingClient;
    }

    @Override
    public KeyValueClient getKeyValueClient() {
        return this.keyValueClient;
    }

    @Override
    public SearchClient getSearchClient() {
        return this.searchClient;
    }
}

