/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.AggregateType;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateTypeResolver
implements ParameterResolver<DeserializingMessage> {
    private static final Logger log = LoggerFactory.getLogger(AggregateTypeResolver.class);

    public Function<DeserializingMessage, Object> resolve(Parameter p) {
        if (p.isAnnotationPresent(AggregateType.class)) {
            return AggregateTypeResolver::getAggregateType;
        }
        return null;
    }

    public static Class<?> getAggregateType(DeserializingMessage message) {
        return Optional.ofNullable(message.getMetadata().get("$aggregateType")).map(c -> {
            try {
                return Class.forName(c);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }).orElse(null);
    }
}

