/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.javaclient.modeling.AggregateRepository;
import io.fluxcapacitor.javaclient.modeling.AggregateRoot;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CompositeAggregateRepository
implements AggregateRepository {
    private final List<AggregateRepository> delegates;

    public CompositeAggregateRepository(AggregateRepository ... delegates) {
        this(Arrays.asList(delegates));
    }

    @Override
    public boolean supports(Class<?> aggregateType) {
        return this.delegates.stream().anyMatch(r -> r.supports(aggregateType));
    }

    @Override
    public boolean cachingAllowed(Class<?> aggregateType) {
        return this.getDelegate(aggregateType).map(d -> d.cachingAllowed(aggregateType)).orElseThrow(() -> new UnsupportedOperationException("Could not a find a suitable aggregate repository for aggregate of type: " + aggregateType));
    }

    @Override
    public <T> AggregateRoot<T> load(String aggregateId, Class<T> aggregateType, boolean readOnly, boolean onlyCached) {
        Optional<AggregateRepository> delegate = this.getDelegate(aggregateType);
        if (delegate.isPresent()) {
            return delegate.get().load(aggregateId, aggregateType, readOnly, onlyCached);
        }
        throw new UnsupportedOperationException("Could not a find a suitable aggregate repository for aggregate of type: " + aggregateType);
    }

    protected <T> Optional<AggregateRepository> getDelegate(Class<T> aggregateType) {
        return this.delegates.stream().filter(r -> r.supports(aggregateType)).findFirst();
    }

    @ConstructorProperties(value={"delegates"})
    public CompositeAggregateRepository(List<AggregateRepository> delegates) {
        this.delegates = delegates;
    }
}

