/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.ConsistentHashing;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingException;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventStoreSerializer;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class DefaultEventStore
implements EventStore {
    private final EventStoreClient client;
    private final EventStoreSerializer serializer;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public Awaitable storeEvents(String aggregateId, String domain, long lastSequenceNumber, List<?> events, boolean storeOnly) {
        Awaitable result;
        ArrayList messages = new ArrayList(events.size());
        try {
            int segment = ConsistentHashing.computeSegment((String)aggregateId);
            events.forEach(e -> {
                DeserializingMessage deserializingMessage;
                if (e instanceof DeserializingMessage) {
                    deserializingMessage = (DeserializingMessage)e;
                } else {
                    Message message = e instanceof Message ? (Message)e : new Message(e);
                    deserializingMessage = new DeserializingMessage(this.serializer.serialize(message), type -> this.serializer.convert(message.getPayload(), type), MessageType.EVENT);
                }
                messages.add(deserializingMessage);
            });
            result = this.client.storeEvents(aggregateId, domain, lastSequenceNumber, messages.stream().map(m -> m.getSerializedObject().getSegment() == null ? m.getSerializedObject().withSegment(Integer.valueOf(segment)) : m.getSerializedObject()).collect(Collectors.toList()), storeOnly);
        }
        catch (Exception e2) {
            throw new EventSourcingException(String.format("Failed to store events %s for aggregate %s", events, aggregateId), e2);
        }
        messages.forEach(m -> this.localHandlerRegistry.handle(m.getPayload(), m.getSerializedObject()));
        return result;
    }

    @Override
    public AggregateEventStream<DeserializingMessage> getEvents(String aggregateId, long lastSequenceNumber) {
        try {
            AggregateEventStream<SerializedMessage> serializedEvents = this.client.getEvents(aggregateId, lastSequenceNumber);
            return serializedEvents.convert(this.serializer::deserializeDomainEvents);
        }
        catch (Exception e) {
            throw new EventSourcingException(String.format("Failed to obtain domain events for aggregate %s", aggregateId), e);
        }
    }

    @ConstructorProperties(value={"client", "serializer", "localHandlerRegistry"})
    public DefaultEventStore(EventStoreClient client, EventStoreSerializer serializer, HandlerRegistry localHandlerRegistry) {
        this.client = client;
        this.serializer = serializer;
        this.localHandlerRegistry = localHandlerRegistry;
    }

    public Optional<CompletableFuture<Message>> handle(Object payload, SerializedMessage serializedMessage) {
        return this.localHandlerRegistry.handle(payload, serializedMessage);
    }

    public HandlerRegistry merge(HandlerRegistry next) {
        return this.localHandlerRegistry.merge(next);
    }

    @Override
    public Registration registerHandler(Object target) {
        return this.localHandlerRegistry.registerHandler(target);
    }

    @Override
    public Registration registerHandler(Object target, HandlerConfiguration<DeserializingMessage> handlerConfiguration) {
        return this.localHandlerRegistry.registerHandler(target, handlerConfiguration);
    }
}

