/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorGateway
implements ErrorGateway {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorGateway.class);
    private final GatewayClient errorGateway;
    private final MessageSerializer serializer;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public void report(Object payload, Metadata metadata, String target) {
        try {
            SerializedMessage message = this.serializer.serialize(new Message(payload, metadata));
            message.setTarget(target);
            Optional<CompletableFuture<Message>> result = this.localHandlerRegistry.handle(payload, message);
            if (result.isPresent() && result.get().isCompletedExceptionally()) {
                try {
                    result.get().getNow(null);
                }
                catch (CompletionException e) {
                    log.error("Failed to handle error locally", (Throwable)e);
                }
            }
            this.errorGateway.send(message);
        }
        catch (Exception e) {
            log.error("Failed to report error {}", payload, (Object)e);
        }
    }

    @ConstructorProperties(value={"errorGateway", "serializer", "localHandlerRegistry"})
    public DefaultErrorGateway(GatewayClient errorGateway, MessageSerializer serializer, HandlerRegistry localHandlerRegistry) {
        this.errorGateway = errorGateway;
        this.serializer = serializer;
        this.localHandlerRegistry = localHandlerRegistry;
    }

    public Optional<CompletableFuture<Message>> handle(Object payload, SerializedMessage serializedMessage) {
        return this.localHandlerRegistry.handle(payload, serializedMessage);
    }

    public HandlerRegistry merge(HandlerRegistry next) {
        return this.localHandlerRegistry.merge(next);
    }

    @Override
    public Registration registerHandler(Object target) {
        return this.localHandlerRegistry.registerHandler(target);
    }

    @Override
    public Registration registerHandler(Object target, HandlerConfiguration<DeserializingMessage> handlerConfiguration) {
        return this.localHandlerRegistry.registerHandler(target, handlerConfiguration);
    }
}

