/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerRegistry;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class DefaultEventGateway
implements EventGateway {
    private final GatewayClient gatewayClient;
    private final MessageSerializer serializer;
    private final HandlerRegistry localHandlerRegistry;

    @Override
    public void publish(Message message) {
        SerializedMessage serializedMessage = this.serializer.serialize(message);
        Optional<CompletableFuture<Message>> result = this.localHandlerRegistry.handle(message.getPayload(), serializedMessage);
        if (result.isPresent() && result.get().isCompletedExceptionally()) {
            try {
                result.get().getNow(null);
            }
            catch (CompletionException e) {
                throw e.getCause();
            }
        }
        try {
            this.gatewayClient.send(serializedMessage);
        }
        catch (Exception e) {
            throw new GatewayException(String.format("Failed to send and forget %s", message.getPayload().toString()), e);
        }
    }

    @ConstructorProperties(value={"gatewayClient", "serializer", "localHandlerRegistry"})
    public DefaultEventGateway(GatewayClient gatewayClient, MessageSerializer serializer, HandlerRegistry localHandlerRegistry) {
        this.gatewayClient = gatewayClient;
        this.serializer = serializer;
        this.localHandlerRegistry = localHandlerRegistry;
    }

    public Optional<CompletableFuture<Message>> handle(Object payload, SerializedMessage serializedMessage) {
        return this.localHandlerRegistry.handle(payload, serializedMessage);
    }

    public HandlerRegistry merge(HandlerRegistry next) {
        return this.localHandlerRegistry.merge(next);
    }

    @Override
    public Registration registerHandler(Object target) {
        return this.localHandlerRegistry.registerHandler(target);
    }

    @Override
    public Registration registerHandler(Object target, HandlerConfiguration<DeserializingMessage> handlerConfiguration) {
        return this.localHandlerRegistry.registerHandler(target, handlerConfiguration);
    }
}

