/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.upcasting;

import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcast;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.stream.Stream;

public class AnnotatedUpcaster<T> {
    private final Method method;
    private final Upcast annotation;
    private final Function<SerializedObject<T, ?>, Stream<SerializedObject<T, ?>>> upcastFunction;

    public AnnotatedUpcaster(Method method, Function<SerializedObject<T, ?>, Stream<SerializedObject<T, ?>>> upcastFunction) {
        this.method = method;
        this.annotation = method.getAnnotation(Upcast.class);
        this.upcastFunction = upcastFunction;
    }

    public <S extends SerializedObject<T, S>> Stream<S> upcast(S input) {
        return this.annotation.type().equals(input.data().getType()) && this.annotation.revision() == input.data().getRevision() ? this.upcastFunction.apply(input) : Stream.of(input);
    }

    public Upcast getAnnotation() {
        return this.annotation;
    }

    public String toString() {
        return this.method.toString();
    }
}

