/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.caching.DefaultCache;
import io.fluxcapacitor.javaclient.common.metrics.ApplicationMonitor;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.common.serialization.jackson.JacksonSerializer;
import io.fluxcapacitor.javaclient.configuration.ConfigurationException;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.eventsourcing.DefaultEventSourcing;
import io.fluxcapacitor.javaclient.eventsourcing.DefaultEventStore;
import io.fluxcapacitor.javaclient.eventsourcing.DefaultSnapshotRepository;
import io.fluxcapacitor.javaclient.eventsourcing.EventSourcing;
import io.fluxcapacitor.javaclient.eventsourcing.EventStoreSerializer;
import io.fluxcapacitor.javaclient.keyvalue.DefaultKeyValueStore;
import io.fluxcapacitor.javaclient.keyvalue.KeyValueStore;
import io.fluxcapacitor.javaclient.publishing.CommandGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultCommandGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultErrorGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultEventGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultGenericGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultMetricsGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultQueryGateway;
import io.fluxcapacitor.javaclient.publishing.DefaultRequestHandler;
import io.fluxcapacitor.javaclient.publishing.DefaultResultGateway;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.publishing.EventGateway;
import io.fluxcapacitor.javaclient.publishing.MetricsGateway;
import io.fluxcapacitor.javaclient.publishing.QueryGateway;
import io.fluxcapacitor.javaclient.publishing.RequestGateway;
import io.fluxcapacitor.javaclient.publishing.RequestHandler;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelatingInterceptor;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelationDataProvider;
import io.fluxcapacitor.javaclient.publishing.correlation.MessageOriginProvider;
import io.fluxcapacitor.javaclient.publishing.dataprotection.DataProtectionInterceptor;
import io.fluxcapacitor.javaclient.publishing.routing.MessageRoutingInterceptor;
import io.fluxcapacitor.javaclient.scheduling.DefaultScheduler;
import io.fluxcapacitor.javaclient.scheduling.Scheduler;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.DefaultTracking;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.TrackingException;
import io.fluxcapacitor.javaclient.tracking.handling.DefaultHandlerFactory;
import io.fluxcapacitor.javaclient.tracking.handling.DeserializingMessageParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCommand;
import io.fluxcapacitor.javaclient.tracking.handling.HandleError;
import io.fluxcapacitor.javaclient.tracking.handling.HandleEvent;
import io.fluxcapacitor.javaclient.tracking.handling.HandleMetrics;
import io.fluxcapacitor.javaclient.tracking.handling.HandleNotification;
import io.fluxcapacitor.javaclient.tracking.handling.HandleQuery;
import io.fluxcapacitor.javaclient.tracking.handling.HandleResult;
import io.fluxcapacitor.javaclient.tracking.handling.HandleSchedule;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.MetadataParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.PayloadParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.errorreporting.ErrorReportingInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidatingInterceptor;
import io.fluxcapacitor.javaclient.tracking.metrics.HandlerMonitor;
import io.fluxcapacitor.javaclient.tracking.metrics.TrackerMonitor;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFluxCapacitor
implements FluxCapacitor {
    private static final Logger log = LoggerFactory.getLogger(DefaultFluxCapacitor.class);
    private final Map<MessageType, ? extends Tracking> trackingSupplier;
    private final CommandGateway commandGateway;
    private final QueryGateway queryGateway;
    private final EventGateway eventGateway;
    private final ResultGateway resultGateway;
    private final ErrorGateway errorGateway;
    private final MetricsGateway metricsGateway;
    private final EventSourcing eventSourcing;
    private final KeyValueStore keyValueStore;
    private final Scheduler scheduler;
    private final Client client;
    private final Properties properties;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public EventSourcing eventSourcing() {
        return this.eventSourcing;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public KeyValueStore keyValueStore() {
        return this.keyValueStore;
    }

    @Override
    public CommandGateway commandGateway() {
        return this.commandGateway;
    }

    @Override
    public QueryGateway queryGateway() {
        return this.queryGateway;
    }

    @Override
    public EventGateway eventGateway() {
        return this.eventGateway;
    }

    @Override
    public ResultGateway resultGateway() {
        return this.resultGateway;
    }

    @Override
    public ErrorGateway errorGateway() {
        return this.errorGateway;
    }

    @Override
    public MetricsGateway metricsGateway() {
        return this.metricsGateway;
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    public Tracking tracking(MessageType messageType) {
        return Optional.ofNullable(this.trackingSupplier.get(messageType)).orElseThrow(() -> new TrackingException(String.format("Tracking is not supported for type %s", messageType)));
    }

    @ConstructorProperties(value={"trackingSupplier", "commandGateway", "queryGateway", "eventGateway", "resultGateway", "errorGateway", "metricsGateway", "eventSourcing", "keyValueStore", "scheduler", "client", "properties"})
    protected DefaultFluxCapacitor(Map<MessageType, ? extends Tracking> trackingSupplier, CommandGateway commandGateway, QueryGateway queryGateway, EventGateway eventGateway, ResultGateway resultGateway, ErrorGateway errorGateway, MetricsGateway metricsGateway, EventSourcing eventSourcing, KeyValueStore keyValueStore, Scheduler scheduler, Client client, Properties properties) {
        this.trackingSupplier = trackingSupplier;
        this.commandGateway = commandGateway;
        this.queryGateway = queryGateway;
        this.eventGateway = eventGateway;
        this.resultGateway = resultGateway;
        this.errorGateway = errorGateway;
        this.metricsGateway = metricsGateway;
        this.eventSourcing = eventSourcing;
        this.keyValueStore = keyValueStore;
        this.scheduler = scheduler;
        this.client = client;
        this.properties = properties;
    }

    public static class Builder
    implements FluxCapacitorBuilder {
        private Serializer serializer;
        private Serializer snapshotSerializer;
        private final Map<MessageType, List<ConsumerConfiguration>> consumerConfigurations;
        private final List<ParameterResolver<? super DeserializingMessage>> handlerParameterResolvers;
        private final Map<MessageType, DispatchInterceptor> dispatchInterceptors;
        private final Map<MessageType, HandlerInterceptor> handlerInterceptors;
        private final Set<CorrelationDataProvider> correlationDataProviders;
        private DispatchInterceptor messageRoutingInterceptor;
        private boolean disableErrorReporting;
        private boolean disableMessageCorrelation;
        private boolean disablePayloadValidation;
        private boolean disableDataProtection;
        private boolean disableShutdownHook;
        private boolean collectTrackingMetrics;
        private boolean collectApplicationMetrics;
        private Properties properties;

        public Builder() {
            this.snapshotSerializer = this.serializer = new JacksonSerializer();
            this.consumerConfigurations = this.defaultConfigurations();
            this.handlerParameterResolvers = this.defaultHandlerParameterResolvers();
            this.dispatchInterceptors = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> f -> f));
            this.handlerInterceptors = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> (f, h, c) -> f));
            this.correlationDataProviders = new LinkedHashSet<CorrelationDataProvider>();
            this.messageRoutingInterceptor = new MessageRoutingInterceptor();
            this.properties = new Properties();
        }

        protected List<ParameterResolver<? super DeserializingMessage>> defaultHandlerParameterResolvers() {
            return new ArrayList<ParameterResolver<? super DeserializingMessage>>(Arrays.asList(new PayloadParameterResolver(), new MetadataParameterResolver(), new DeserializingMessageParameterResolver()));
        }

        protected Map<MessageType, List<ConsumerConfiguration>> defaultConfigurations() {
            return Collections.unmodifiableMap(Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), messageType -> new ArrayList<ConsumerConfiguration>(Collections.singletonList(ConsumerConfiguration.getDefault(messageType))))));
        }

        @Override
        public Builder serializer(Serializer serializer) {
            if (this.snapshotSerializer == this.serializer) {
                this.snapshotSerializer = serializer;
            }
            this.serializer = serializer;
            return this;
        }

        @Override
        public Builder snapshotSerializer(Serializer serializer) {
            this.snapshotSerializer = serializer;
            return this;
        }

        @Override
        public Builder configureDefaultConsumer(MessageType messageType, UnaryOperator<ConsumerConfiguration> updateFunction) {
            List<ConsumerConfiguration> configurations = this.consumerConfigurations.get(messageType);
            ConsumerConfiguration defaultConfiguration = configurations.get(configurations.size() - 1);
            configurations.set(configurations.size() - 1, (ConsumerConfiguration)updateFunction.apply(defaultConfiguration));
            return this;
        }

        @Override
        public Builder addConsumerConfiguration(MessageType messageType, ConsumerConfiguration consumerConfiguration) {
            List<ConsumerConfiguration> configurations = this.consumerConfigurations.get(messageType);
            configurations.add(configurations.size() - 1, consumerConfiguration);
            return this;
        }

        @Override
        public Builder addHandlerParameterResolver(ParameterResolver<DeserializingMessage> parameterResolver) {
            this.handlerParameterResolvers.add(parameterResolver);
            return this;
        }

        @Override
        public Builder addDispatchInterceptor(DispatchInterceptor interceptor, MessageType ... forTypes) {
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> this.dispatchInterceptors.compute((MessageType)type, (t, i) -> i.merge(interceptor)));
            return this;
        }

        @Override
        public Builder addHandlerInterceptor(HandlerInterceptor interceptor, MessageType ... forTypes) {
            Arrays.stream(forTypes.length == 0 ? MessageType.values() : forTypes).forEach(type -> this.handlerInterceptors.compute((MessageType)type, (t, i) -> i.merge(interceptor)));
            return this;
        }

        @Override
        public Builder addCorrelationDataProvider(CorrelationDataProvider dataProvider) {
            this.correlationDataProviders.add(dataProvider);
            return this;
        }

        @Override
        public Builder changeMessageRoutingInterceptor(DispatchInterceptor messageRoutingInterceptor) {
            this.messageRoutingInterceptor = messageRoutingInterceptor;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableErrorReporting() {
            this.disableErrorReporting = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableShutdownHook() {
            this.disableShutdownHook = true;
            return this;
        }

        @Override
        public Builder disableMessageCorrelation() {
            this.disableMessageCorrelation = true;
            return this;
        }

        @Override
        public Builder disablePayloadValidation() {
            this.disablePayloadValidation = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder disableDataProtection() {
            this.disableDataProtection = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder collectTrackingMetrics() {
            this.collectTrackingMetrics = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder collectApplicationMetrics() {
            this.collectApplicationMetrics = true;
            return this;
        }

        @Override
        public FluxCapacitorBuilder registerProperties(Properties properties) {
            this.properties.putAll((Map<?, ?>)properties);
            return this;
        }

        @Override
        public FluxCapacitor build(Client client) {
            HashMap<MessageType, DispatchInterceptor> dispatchInterceptors = new HashMap<MessageType, DispatchInterceptor>(this.dispatchInterceptors);
            HashMap<MessageType, HandlerInterceptor> handlerInterceptors = new HashMap<MessageType, HandlerInterceptor>(this.handlerInterceptors);
            HashMap<MessageType, List<ConsumerConfiguration>> consumerConfigurations = new HashMap<MessageType, List<ConsumerConfiguration>>(this.consumerConfigurations);
            DefaultKeyValueStore keyValueStore = new DefaultKeyValueStore(client.getKeyValueClient(), this.serializer);
            Arrays.stream(MessageType.values()).forEach(type -> dispatchInterceptors.compute((MessageType)type, (t, i) -> i.merge(this.messageRoutingInterceptor)));
            if (!this.disableDataProtection) {
                DataProtectionInterceptor interceptor = new DataProtectionInterceptor(keyValueStore, this.serializer);
                Stream.of(MessageType.COMMAND, MessageType.EVENT, MessageType.QUERY, MessageType.RESULT, MessageType.SCHEDULE).forEach(type -> {
                    dispatchInterceptors.compute((MessageType)type, (t, i) -> i.merge(interceptor));
                    handlerInterceptors.compute((MessageType)type, (t, i) -> i.merge(interceptor));
                });
            }
            if (!this.disableMessageCorrelation) {
                LinkedHashSet<CorrelationDataProvider> dataProviders = new LinkedHashSet<CorrelationDataProvider>(this.correlationDataProviders);
                dataProviders.add(new MessageOriginProvider(client));
                CorrelatingInterceptor correlatingInterceptor = new CorrelatingInterceptor(dataProviders);
                Arrays.stream(MessageType.values()).forEach(type -> dispatchInterceptors.compute((MessageType)type, (t, i) -> correlatingInterceptor.merge((DispatchInterceptor)i)));
            }
            if (!this.disablePayloadValidation) {
                Stream.of(MessageType.COMMAND, MessageType.QUERY).forEach(type -> handlerInterceptors.compute((MessageType)type, (t, i) -> i.merge(new ValidatingInterceptor())));
            }
            if (this.collectTrackingMetrics) {
                TrackerMonitor batchInterceptor = new TrackerMonitor();
                HandlerMonitor handlerMonitor = new HandlerMonitor();
                Arrays.stream(MessageType.values()).forEach(type -> {
                    consumerConfigurations.compute((MessageType)type, (t, list) -> t == MessageType.METRICS ? list : list.stream().map(c -> c.toBuilder().trackingConfiguration(c.getTrackingConfiguration().toBuilder().batchInterceptor(batchInterceptor).build()).build()).collect(Collectors.toList()));
                    handlerInterceptors.compute((MessageType)type, (t, i) -> t == MessageType.METRICS ? i : handlerMonitor.merge((HandlerInterceptor)i));
                });
            }
            DefaultEventStore eventStore = new DefaultEventStore(client.getEventStoreClient(), new EventStoreSerializer(this.serializer, (DispatchInterceptor)dispatchInterceptors.get(MessageType.EVENT)), new DefaultHandlerFactory(MessageType.EVENT, (HandlerInterceptor)handlerInterceptors.get(MessageType.EVENT), this.handlerParameterResolvers));
            DefaultSnapshotRepository snapshotRepository = new DefaultSnapshotRepository(client.getKeyValueClient(), this.snapshotSerializer);
            DefaultEventSourcing eventSourcing = new DefaultEventSourcing(eventStore, snapshotRepository, new DefaultCache());
            handlerInterceptors.compute(MessageType.COMMAND, (t, i) -> i.merge(eventSourcing));
            DefaultErrorGateway errorGateway = new DefaultErrorGateway(client.getGatewayClient(MessageType.ERROR), new MessageSerializer(this.serializer, (DispatchInterceptor)dispatchInterceptors.get(MessageType.ERROR)));
            if (!this.disableErrorReporting) {
                ErrorReportingInterceptor interceptor = new ErrorReportingInterceptor(errorGateway);
                Arrays.stream(MessageType.values()).forEach(type -> handlerInterceptors.compute((MessageType)type, (t, i) -> interceptor.merge((HandlerInterceptor)i)));
            }
            DefaultResultGateway resultGateway = new DefaultResultGateway(client.getGatewayClient(MessageType.RESULT), new MessageSerializer(this.serializer, (DispatchInterceptor)dispatchInterceptors.get(MessageType.RESULT)));
            DefaultRequestHandler requestHandler = new DefaultRequestHandler(client.getTrackingClient(MessageType.RESULT), this.serializer, client.name(), client.id());
            DefaultCommandGateway commandGateway = new DefaultCommandGateway(this.createRequestGateway(client, MessageType.COMMAND, requestHandler, (DispatchInterceptor)dispatchInterceptors.get(MessageType.COMMAND), new DefaultHandlerFactory(MessageType.COMMAND, (HandlerInterceptor)handlerInterceptors.get(MessageType.COMMAND), this.handlerParameterResolvers)));
            DefaultQueryGateway queryGateway = new DefaultQueryGateway(this.createRequestGateway(client, MessageType.QUERY, requestHandler, (DispatchInterceptor)dispatchInterceptors.get(MessageType.QUERY), new DefaultHandlerFactory(MessageType.QUERY, (HandlerInterceptor)handlerInterceptors.get(MessageType.QUERY), this.handlerParameterResolvers)));
            DefaultEventGateway eventGateway = new DefaultEventGateway(client.getGatewayClient(MessageType.EVENT), new MessageSerializer(this.serializer, (DispatchInterceptor)dispatchInterceptors.get(MessageType.EVENT)), new DefaultHandlerFactory(MessageType.EVENT, (HandlerInterceptor)handlerInterceptors.get(MessageType.EVENT), this.handlerParameterResolvers));
            DefaultMetricsGateway metricsGateway = new DefaultMetricsGateway(client.getGatewayClient(MessageType.METRICS), new MessageSerializer(this.serializer, (DispatchInterceptor)dispatchInterceptors.get(MessageType.METRICS)));
            Map<MessageType, Tracking> trackingMap = Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), m -> new DefaultTracking((MessageType)m, this.getHandlerAnnotation((MessageType)m), client.getTrackingClient((MessageType)m), resultGateway, (List)consumerConfigurations.get(m), this.serializer, (HandlerInterceptor)handlerInterceptors.get(m), this.handlerParameterResolvers)));
            DefaultScheduler scheduler = new DefaultScheduler(client.getSchedulingClient(), new MessageSerializer(this.serializer, (DispatchInterceptor)dispatchInterceptors.get(MessageType.SCHEDULE)));
            FluxCapacitor fluxCapacitor = this.doBuild(trackingMap, commandGateway, queryGateway, eventGateway, resultGateway, errorGateway, metricsGateway, eventSourcing, keyValueStore, scheduler, client, this.properties);
            if (this.collectApplicationMetrics) {
                ApplicationMonitor.start(fluxCapacitor, Duration.ofSeconds(1L));
            }
            if (!this.disableShutdownHook) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    log.info("Initiating controlled shutdown");
                    trackingMap.values().forEach(Tracking::close);
                    client.shutDown();
                    log.info("Completed shutdown");
                }));
            }
            return fluxCapacitor;
        }

        protected FluxCapacitor doBuild(Map<MessageType, ? extends Tracking> trackingSupplier, CommandGateway commandGateway, QueryGateway queryGateway, EventGateway eventGateway, ResultGateway resultGateway, ErrorGateway errorGateway, MetricsGateway metricsGateway, EventSourcing eventSourcing, KeyValueStore keyValueStore, Scheduler scheduler, Client client, Properties properties) {
            return new DefaultFluxCapacitor(trackingSupplier, commandGateway, queryGateway, eventGateway, resultGateway, errorGateway, metricsGateway, eventSourcing, keyValueStore, scheduler, client, properties);
        }

        protected Class<? extends Annotation> getHandlerAnnotation(MessageType messageType) {
            switch (messageType) {
                case COMMAND: {
                    return HandleCommand.class;
                }
                case EVENT: {
                    return HandleEvent.class;
                }
                case NOTIFICATION: {
                    return HandleNotification.class;
                }
                case QUERY: {
                    return HandleQuery.class;
                }
                case RESULT: {
                    return HandleResult.class;
                }
                case ERROR: {
                    return HandleError.class;
                }
                case SCHEDULE: {
                    return HandleSchedule.class;
                }
                case METRICS: {
                    return HandleMetrics.class;
                }
            }
            throw new ConfigurationException(String.format("Unrecognized type: %s", messageType));
        }

        protected RequestGateway createRequestGateway(Client client, MessageType messageType, RequestHandler requestHandler, DispatchInterceptor dispatchInterceptor, DefaultHandlerFactory handlerFactory) {
            return new DefaultGenericGateway(messageType, client.getGatewayClient(messageType), requestHandler, new MessageSerializer(this.serializer, dispatchInterceptor), handlerFactory);
        }
    }
}

