/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.javaclient.common.websocket.ServiceUrlBuilder;
import io.fluxcapacitor.javaclient.configuration.client.AbstractClient;
import io.fluxcapacitor.javaclient.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.eventsourcing.client.WebSocketEventStoreClient;
import io.fluxcapacitor.javaclient.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.keyvalue.client.WebsocketKeyValueClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.publishing.client.WebsocketGatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.scheduling.client.WebsocketSchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.WebsocketTrackingClient;
import java.beans.ConstructorProperties;
import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;

public class WebSocketClient
extends AbstractClient {
    public static WebSocketClient newInstance(Properties properties) {
        return new WebSocketClient(properties.getName(), properties.getId(), type -> new WebsocketGatewayClient(ServiceUrlBuilder.producerUrl(type, properties)), type -> new WebsocketTrackingClient(ServiceUrlBuilder.consumerUrl(type, properties)), new WebSocketEventStoreClient(ServiceUrlBuilder.eventSourcingUrl(properties)), new WebsocketSchedulingClient(ServiceUrlBuilder.schedulingUrl(properties)), new WebsocketKeyValueClient(ServiceUrlBuilder.keyValueUrl(properties)));
    }

    private WebSocketClient(String name, String id, Function<MessageType, ? extends GatewayClient> gatewayClients, Function<MessageType, ? extends TrackingClient> trackingClients, EventStoreClient eventStoreClient, SchedulingClient schedulingClient, KeyValueClient keyValueClient) {
        super(name, id, gatewayClients, trackingClients, eventStoreClient, schedulingClient, keyValueClient);
    }

    @Override
    public void shutDown() {
        super.shutDown();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static final class Properties {
        @NonNull
        private final String name;
        @NonNull
        private final String id;
        @NonNull
        private final String serviceBaseUrl;
        private final String projectId;
        private final String typeFilter;

        public Properties(String name, String serviceBaseUrl, String projectId) {
            this(name, UUID.randomUUID().toString(), serviceBaseUrl, projectId, null);
        }

        public Properties(String name, String serviceBaseUrl) {
            this(name, UUID.randomUUID().toString(), serviceBaseUrl, null, null);
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        @NonNull
        public String getServiceBaseUrl() {
            return this.serviceBaseUrl;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getTypeFilter() {
            return this.typeFilter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties other = (Properties)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$serviceBaseUrl = this.getServiceBaseUrl();
            String other$serviceBaseUrl = other.getServiceBaseUrl();
            if (this$serviceBaseUrl == null ? other$serviceBaseUrl != null : !this$serviceBaseUrl.equals(other$serviceBaseUrl)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            String this$typeFilter = this.getTypeFilter();
            String other$typeFilter = other.getTypeFilter();
            return !(this$typeFilter == null ? other$typeFilter != null : !this$typeFilter.equals(other$typeFilter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $serviceBaseUrl = this.getServiceBaseUrl();
            result = result * 59 + ($serviceBaseUrl == null ? 43 : $serviceBaseUrl.hashCode());
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            String $typeFilter = this.getTypeFilter();
            result = result * 59 + ($typeFilter == null ? 43 : $typeFilter.hashCode());
            return result;
        }

        public String toString() {
            return "WebSocketClient.Properties(name=" + this.getName() + ", id=" + this.getId() + ", serviceBaseUrl=" + this.getServiceBaseUrl() + ", projectId=" + this.getProjectId() + ", typeFilter=" + this.getTypeFilter() + ")";
        }

        @ConstructorProperties(value={"name", "id", "serviceBaseUrl", "projectId", "typeFilter"})
        public Properties(@NonNull String name, @NonNull String id, @NonNull String serviceBaseUrl, String projectId, String typeFilter) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            if (id == null) {
                throw new NullPointerException("id is marked @NonNull but is null");
            }
            if (serviceBaseUrl == null) {
                throw new NullPointerException("serviceBaseUrl is marked @NonNull but is null");
            }
            this.name = name;
            this.id = id;
            this.serviceBaseUrl = serviceBaseUrl;
            this.projectId = projectId;
            this.typeFilter = typeFilter;
        }
    }
}

