/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.eventsourcing;

import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.eventsourcing.Aggregate;
import io.fluxcapacitor.javaclient.eventsourcing.SnapshotTrigger;
import java.util.List;

public class PeriodicSnapshotTrigger
implements SnapshotTrigger {
    private final int period;

    public PeriodicSnapshotTrigger(int period) {
        if (period < 1) {
            throw new IllegalArgumentException("Period should be at least 1");
        }
        this.period = period;
    }

    @Override
    public boolean shouldCreateSnapshot(Aggregate<?> aggregate, List<Message> newEvents) {
        return this.periodIndex(aggregate.getSequenceNumber()) > this.periodIndex(aggregate.getSequenceNumber() - (long)newEvents.size());
    }

    protected long periodIndex(long sequenceNumber) {
        return (sequenceNumber + 1L) / (long)this.period;
    }
}

