/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.MessageSerializer;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.RequestGateway;
import io.fluxcapacitor.javaclient.publishing.RequestHandler;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultGenericGateway
implements RequestGateway {
    private final MessageType messageType;
    private final GatewayClient gatewayClient;
    private final RequestHandler requestHandler;
    private final MessageSerializer serializer;
    private final HandlerFactory handlerFactory;
    private final List<Handler<DeserializingMessage>> localHandlers = new CopyOnWriteArrayList<Handler<DeserializingMessage>>();

    @Override
    public void sendAndForget(Message message) {
        SerializedMessage serializedMessage = this.serializer.serialize(message);
        CompletableFuture<Message> localResult = this.tryHandleLocally(message.getPayload(), serializedMessage);
        if (localResult == null) {
            try {
                this.gatewayClient.send(serializedMessage);
            }
            catch (Exception e) {
                throw new GatewayException(String.format("Failed to send and forget %s", (Object[])message.getPayload()), e);
            }
        }
    }

    @Override
    public CompletableFuture<Message> sendForMessage(Message message) {
        SerializedMessage serializedMessage = this.serializer.serialize(message);
        CompletableFuture<Message> localResult = this.tryHandleLocally(message.getPayload(), serializedMessage);
        if (localResult == null) {
            try {
                return this.requestHandler.sendRequest(serializedMessage, xva$0 -> this.gatewayClient.send((SerializedMessage)xva$0));
            }
            catch (Exception e) {
                throw new GatewayException(String.format("Failed to send %s", (Object[])message.getPayload()), e);
            }
        }
        return localResult;
    }

    @Override
    public Registration registerLocalHandler(Object target) {
        Optional<Handler<DeserializingMessage>> handler = this.handlerFactory.createHandler(target);
        handler.ifPresent(this.localHandlers::add);
        return () -> handler.ifPresent(this.localHandlers::remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Message> tryHandleLocally(Object payload, SerializedMessage serializedMessage) {
        if (!this.localHandlers.isEmpty()) {
            DeserializingMessage current = DeserializingMessage.getCurrent();
            try {
                DeserializingMessage deserializingMessage = new DeserializingMessage(new DeserializingObject<byte[], SerializedMessage>(serializedMessage, () -> payload), this.messageType);
                DeserializingMessage.setCurrent(deserializingMessage);
                for (Handler<DeserializingMessage> handler : this.localHandlers) {
                    if (!handler.canHandle((Object)deserializingMessage)) continue;
                    CompletableFuture<Message> completableFuture = CompletableFuture.completedFuture(new Message(handler.invoke((Object)deserializingMessage), this.messageType));
                    return completableFuture;
                }
            }
            finally {
                DeserializingMessage.setCurrent(current);
            }
        }
        return null;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }

    @ConstructorProperties(value={"messageType", "gatewayClient", "requestHandler", "serializer", "handlerFactory"})
    public DefaultGenericGateway(MessageType messageType, GatewayClient gatewayClient, RequestHandler requestHandler, MessageSerializer serializer, HandlerFactory handlerFactory) {
        this.messageType = messageType;
        this.gatewayClient = gatewayClient;
        this.requestHandler = requestHandler;
        this.serializer = serializer;
        this.handlerFactory = handlerFactory;
    }
}

