/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.publishing.Append;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.common.websocket.JsonDecoder;
import io.fluxcapacitor.javaclient.common.websocket.JsonEncoder;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import javax.websocket.ClientEndpoint;

@ClientEndpoint(encoders={JsonEncoder.class}, decoders={JsonDecoder.class})
public class WebsocketGatewayClient
extends AbstractWebsocketClient
implements GatewayClient {
    private final Backlog<SerializedMessage> backlog;

    public WebsocketGatewayClient(String endPointUrl) {
        this(URI.create(endPointUrl), 1024);
    }

    public WebsocketGatewayClient(String endPointUrl, int backlogSize) {
        this(URI.create(endPointUrl), backlogSize);
    }

    public WebsocketGatewayClient(URI endPointUri, int backlogSize) {
        super(endPointUri);
        this.backlog = new Backlog(this::doSend, backlogSize);
    }

    @Override
    public Awaitable send(SerializedMessage ... messages) {
        return this.backlog.add((Object[])messages);
    }

    public Registration registerMonitor(Consumer<SerializedMessage> monitor) {
        return this.backlog.registerMonitor(messages -> messages.forEach(monitor));
    }

    private Awaitable doSend(List<SerializedMessage> messages) {
        return this.send(new Append(messages));
    }
}

