/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.javaclient.tracking.ErrorHandler;
import io.fluxcapacitor.javaclient.tracking.LoggingErrorHandler;
import io.fluxcapacitor.javaclient.tracking.TrackingConfiguration;
import java.beans.ConstructorProperties;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ConsumerConfiguration {
    public static Function<MessageType, String> DEFAULT_CONSUMER_NAME = Enum::name;
    private final String name;
    private final boolean prependApplicationName;
    private final Predicate<Object> handlerFilter;
    private final TrackingConfiguration trackingConfiguration;
    private final ErrorHandler errorHandler;

    public static ConsumerConfiguration getDefault(MessageType messageType) {
        return ConsumerConfiguration.builder().name(DEFAULT_CONSUMER_NAME.apply(messageType)).build();
    }

    public boolean prependApplicationName() {
        return this.prependApplicationName;
    }

    private static boolean $default$prependApplicationName() {
        return true;
    }

    private static Predicate<Object> $default$handlerFilter() {
        return o -> true;
    }

    private static TrackingConfiguration $default$trackingConfiguration() {
        return TrackingConfiguration.DEFAULT;
    }

    private static ErrorHandler $default$errorHandler() {
        return new LoggingErrorHandler();
    }

    @ConstructorProperties(value={"name", "prependApplicationName", "handlerFilter", "trackingConfiguration", "errorHandler"})
    ConsumerConfiguration(String name, boolean prependApplicationName, Predicate<Object> handlerFilter, TrackingConfiguration trackingConfiguration, ErrorHandler errorHandler) {
        this.name = name;
        this.prependApplicationName = prependApplicationName;
        this.handlerFilter = handlerFilter;
        this.trackingConfiguration = trackingConfiguration;
        this.errorHandler = errorHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().name(this.name).prependApplicationName(this.prependApplicationName).handlerFilter(this.handlerFilter).trackingConfiguration(this.trackingConfiguration).errorHandler(this.errorHandler);
    }

    public String getName() {
        return this.name;
    }

    public Predicate<Object> getHandlerFilter() {
        return this.handlerFilter;
    }

    public TrackingConfiguration getTrackingConfiguration() {
        return this.trackingConfiguration;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerConfiguration)) {
            return false;
        }
        ConsumerConfiguration other = (ConsumerConfiguration)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.prependApplicationName != other.prependApplicationName) {
            return false;
        }
        Predicate<Object> this$handlerFilter = this.getHandlerFilter();
        Predicate<Object> other$handlerFilter = other.getHandlerFilter();
        if (this$handlerFilter == null ? other$handlerFilter != null : !this$handlerFilter.equals(other$handlerFilter)) {
            return false;
        }
        TrackingConfiguration this$trackingConfiguration = this.getTrackingConfiguration();
        TrackingConfiguration other$trackingConfiguration = other.getTrackingConfiguration();
        if (this$trackingConfiguration == null ? other$trackingConfiguration != null : !((Object)this$trackingConfiguration).equals(other$trackingConfiguration)) {
            return false;
        }
        ErrorHandler this$errorHandler = this.getErrorHandler();
        ErrorHandler other$errorHandler = other.getErrorHandler();
        return !(this$errorHandler == null ? other$errorHandler != null : !this$errorHandler.equals(other$errorHandler));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + (this.prependApplicationName ? 79 : 97);
        Predicate<Object> $handlerFilter = this.getHandlerFilter();
        result = result * 59 + ($handlerFilter == null ? 43 : $handlerFilter.hashCode());
        TrackingConfiguration $trackingConfiguration = this.getTrackingConfiguration();
        result = result * 59 + ($trackingConfiguration == null ? 43 : ((Object)$trackingConfiguration).hashCode());
        ErrorHandler $errorHandler = this.getErrorHandler();
        result = result * 59 + ($errorHandler == null ? 43 : $errorHandler.hashCode());
        return result;
    }

    public String toString() {
        return "ConsumerConfiguration(name=" + this.getName() + ", prependApplicationName=" + this.prependApplicationName + ", handlerFilter=" + this.getHandlerFilter() + ", trackingConfiguration=" + this.getTrackingConfiguration() + ", errorHandler=" + this.getErrorHandler() + ")";
    }

    public static class Builder {
        private String name;
        private boolean prependApplicationName$set;
        private boolean prependApplicationName;
        private boolean handlerFilter$set;
        private Predicate<Object> handlerFilter;
        private boolean trackingConfiguration$set;
        private TrackingConfiguration trackingConfiguration;
        private boolean errorHandler$set;
        private ErrorHandler errorHandler;

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder prependApplicationName(boolean prependApplicationName) {
            this.prependApplicationName = prependApplicationName;
            this.prependApplicationName$set = true;
            return this;
        }

        public Builder handlerFilter(Predicate<Object> handlerFilter) {
            this.handlerFilter = handlerFilter;
            this.handlerFilter$set = true;
            return this;
        }

        public Builder trackingConfiguration(TrackingConfiguration trackingConfiguration) {
            this.trackingConfiguration = trackingConfiguration;
            this.trackingConfiguration$set = true;
            return this;
        }

        public Builder errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            this.errorHandler$set = true;
            return this;
        }

        public ConsumerConfiguration build() {
            boolean prependApplicationName = this.prependApplicationName;
            if (!this.prependApplicationName$set) {
                prependApplicationName = ConsumerConfiguration.$default$prependApplicationName();
            }
            Predicate handlerFilter = this.handlerFilter;
            if (!this.handlerFilter$set) {
                handlerFilter = ConsumerConfiguration.$default$handlerFilter();
            }
            TrackingConfiguration trackingConfiguration = this.trackingConfiguration;
            if (!this.trackingConfiguration$set) {
                trackingConfiguration = ConsumerConfiguration.$default$trackingConfiguration();
            }
            ErrorHandler errorHandler = this.errorHandler;
            if (!this.errorHandler$set) {
                errorHandler = ConsumerConfiguration.$default$errorHandler();
            }
            return new ConsumerConfiguration(this.name, prependApplicationName, handlerFilter, trackingConfiguration, errorHandler);
        }

        public String toString() {
            return "ConsumerConfiguration.Builder(name=" + this.name + ", prependApplicationName=" + this.prependApplicationName + ", handlerFilter=" + this.handlerFilter + ", trackingConfiguration=" + this.trackingConfiguration + ", errorHandler=" + this.errorHandler + ")";
        }
    }
}

