/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.api.tracking.TrackingStrategy;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class TrackingConfiguration {
    public static final TrackingConfiguration DEFAULT = TrackingConfiguration.builder().build();
    private final int threads;
    private final String typeFilter;
    private final int maxFetchBatchSize;
    private final int maxConsumerBatchSize;
    private final Duration maxWaitDuration;
    private final Duration retryDelay;
    private final List<BatchInterceptor> batchInterceptors;
    private final boolean ignoreMessageTarget;
    private final TrackingStrategy readStrategy;

    private static int $default$threads() {
        return 1;
    }

    private static String $default$typeFilter() {
        return null;
    }

    private static int $default$maxFetchBatchSize() {
        return 1024;
    }

    private static int $default$maxConsumerBatchSize() {
        return 1024;
    }

    private static Duration $default$maxWaitDuration() {
        return Duration.ofSeconds(60L);
    }

    private static Duration $default$retryDelay() {
        return Duration.ofSeconds(1L);
    }

    private static boolean $default$ignoreMessageTarget() {
        return false;
    }

    private static TrackingStrategy $default$readStrategy() {
        return TrackingStrategy.TYPE_DEFAULT;
    }

    @ConstructorProperties(value={"threads", "typeFilter", "maxFetchBatchSize", "maxConsumerBatchSize", "maxWaitDuration", "retryDelay", "batchInterceptors", "ignoreMessageTarget", "readStrategy"})
    TrackingConfiguration(int threads, String typeFilter, int maxFetchBatchSize, int maxConsumerBatchSize, Duration maxWaitDuration, Duration retryDelay, List<BatchInterceptor> batchInterceptors, boolean ignoreMessageTarget, TrackingStrategy readStrategy) {
        this.threads = threads;
        this.typeFilter = typeFilter;
        this.maxFetchBatchSize = maxFetchBatchSize;
        this.maxConsumerBatchSize = maxConsumerBatchSize;
        this.maxWaitDuration = maxWaitDuration;
        this.retryDelay = retryDelay;
        this.batchInterceptors = batchInterceptors;
        this.ignoreMessageTarget = ignoreMessageTarget;
        this.readStrategy = readStrategy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().threads(this.threads).typeFilter(this.typeFilter).maxFetchBatchSize(this.maxFetchBatchSize).maxConsumerBatchSize(this.maxConsumerBatchSize).maxWaitDuration(this.maxWaitDuration).retryDelay(this.retryDelay).batchInterceptors(this.batchInterceptors).ignoreMessageTarget(this.ignoreMessageTarget).readStrategy(this.readStrategy);
    }

    public int getThreads() {
        return this.threads;
    }

    public String getTypeFilter() {
        return this.typeFilter;
    }

    public int getMaxFetchBatchSize() {
        return this.maxFetchBatchSize;
    }

    public int getMaxConsumerBatchSize() {
        return this.maxConsumerBatchSize;
    }

    public Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public List<BatchInterceptor> getBatchInterceptors() {
        return this.batchInterceptors;
    }

    public boolean ignoreMessageTarget() {
        return this.ignoreMessageTarget;
    }

    public TrackingStrategy getReadStrategy() {
        return this.readStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrackingConfiguration)) {
            return false;
        }
        TrackingConfiguration other = (TrackingConfiguration)o;
        if (this.getThreads() != other.getThreads()) {
            return false;
        }
        String this$typeFilter = this.getTypeFilter();
        String other$typeFilter = other.getTypeFilter();
        if (this$typeFilter == null ? other$typeFilter != null : !this$typeFilter.equals(other$typeFilter)) {
            return false;
        }
        if (this.getMaxFetchBatchSize() != other.getMaxFetchBatchSize()) {
            return false;
        }
        if (this.getMaxConsumerBatchSize() != other.getMaxConsumerBatchSize()) {
            return false;
        }
        Duration this$maxWaitDuration = this.getMaxWaitDuration();
        Duration other$maxWaitDuration = other.getMaxWaitDuration();
        if (this$maxWaitDuration == null ? other$maxWaitDuration != null : !((Object)this$maxWaitDuration).equals(other$maxWaitDuration)) {
            return false;
        }
        Duration this$retryDelay = this.getRetryDelay();
        Duration other$retryDelay = other.getRetryDelay();
        if (this$retryDelay == null ? other$retryDelay != null : !((Object)this$retryDelay).equals(other$retryDelay)) {
            return false;
        }
        List<BatchInterceptor> this$batchInterceptors = this.getBatchInterceptors();
        List<BatchInterceptor> other$batchInterceptors = other.getBatchInterceptors();
        if (this$batchInterceptors == null ? other$batchInterceptors != null : !((Object)this$batchInterceptors).equals(other$batchInterceptors)) {
            return false;
        }
        if (this.ignoreMessageTarget() != other.ignoreMessageTarget()) {
            return false;
        }
        TrackingStrategy this$readStrategy = this.getReadStrategy();
        TrackingStrategy other$readStrategy = other.getReadStrategy();
        return !(this$readStrategy == null ? other$readStrategy != null : !this$readStrategy.equals(other$readStrategy));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getThreads();
        String $typeFilter = this.getTypeFilter();
        result = result * 59 + ($typeFilter == null ? 43 : $typeFilter.hashCode());
        result = result * 59 + this.getMaxFetchBatchSize();
        result = result * 59 + this.getMaxConsumerBatchSize();
        Duration $maxWaitDuration = this.getMaxWaitDuration();
        result = result * 59 + ($maxWaitDuration == null ? 43 : ((Object)$maxWaitDuration).hashCode());
        Duration $retryDelay = this.getRetryDelay();
        result = result * 59 + ($retryDelay == null ? 43 : ((Object)$retryDelay).hashCode());
        List<BatchInterceptor> $batchInterceptors = this.getBatchInterceptors();
        result = result * 59 + ($batchInterceptors == null ? 43 : ((Object)$batchInterceptors).hashCode());
        result = result * 59 + (this.ignoreMessageTarget() ? 79 : 97);
        TrackingStrategy $readStrategy = this.getReadStrategy();
        result = result * 59 + ($readStrategy == null ? 43 : $readStrategy.hashCode());
        return result;
    }

    public String toString() {
        return "TrackingConfiguration(threads=" + this.getThreads() + ", typeFilter=" + this.getTypeFilter() + ", maxFetchBatchSize=" + this.getMaxFetchBatchSize() + ", maxConsumerBatchSize=" + this.getMaxConsumerBatchSize() + ", maxWaitDuration=" + this.getMaxWaitDuration() + ", retryDelay=" + this.getRetryDelay() + ", batchInterceptors=" + this.getBatchInterceptors() + ", ignoreMessageTarget=" + this.ignoreMessageTarget() + ", readStrategy=" + this.getReadStrategy() + ")";
    }

    public static class Builder {
        private boolean threads$set;
        private int threads;
        private boolean typeFilter$set;
        private String typeFilter;
        private boolean maxFetchBatchSize$set;
        private int maxFetchBatchSize;
        private boolean maxConsumerBatchSize$set;
        private int maxConsumerBatchSize;
        private boolean maxWaitDuration$set;
        private Duration maxWaitDuration;
        private boolean retryDelay$set;
        private Duration retryDelay;
        private ArrayList<BatchInterceptor> batchInterceptors;
        private boolean ignoreMessageTarget$set;
        private boolean ignoreMessageTarget;
        private boolean readStrategy$set;
        private TrackingStrategy readStrategy;

        Builder() {
        }

        public Builder threads(int threads) {
            this.threads = threads;
            this.threads$set = true;
            return this;
        }

        public Builder typeFilter(String typeFilter) {
            this.typeFilter = typeFilter;
            this.typeFilter$set = true;
            return this;
        }

        public Builder maxFetchBatchSize(int maxFetchBatchSize) {
            this.maxFetchBatchSize = maxFetchBatchSize;
            this.maxFetchBatchSize$set = true;
            return this;
        }

        public Builder maxConsumerBatchSize(int maxConsumerBatchSize) {
            this.maxConsumerBatchSize = maxConsumerBatchSize;
            this.maxConsumerBatchSize$set = true;
            return this;
        }

        public Builder maxWaitDuration(Duration maxWaitDuration) {
            this.maxWaitDuration = maxWaitDuration;
            this.maxWaitDuration$set = true;
            return this;
        }

        public Builder retryDelay(Duration retryDelay) {
            this.retryDelay = retryDelay;
            this.retryDelay$set = true;
            return this;
        }

        public Builder batchInterceptor(BatchInterceptor batchInterceptor) {
            if (this.batchInterceptors == null) {
                this.batchInterceptors = new ArrayList();
            }
            this.batchInterceptors.add(batchInterceptor);
            return this;
        }

        public Builder batchInterceptors(Collection<? extends BatchInterceptor> batchInterceptors) {
            if (this.batchInterceptors == null) {
                this.batchInterceptors = new ArrayList();
            }
            this.batchInterceptors.addAll(batchInterceptors);
            return this;
        }

        public Builder clearBatchInterceptors() {
            if (this.batchInterceptors != null) {
                this.batchInterceptors.clear();
            }
            return this;
        }

        public Builder ignoreMessageTarget(boolean ignoreMessageTarget) {
            this.ignoreMessageTarget = ignoreMessageTarget;
            this.ignoreMessageTarget$set = true;
            return this;
        }

        public Builder readStrategy(TrackingStrategy readStrategy) {
            this.readStrategy = readStrategy;
            this.readStrategy$set = true;
            return this;
        }

        public TrackingConfiguration build() {
            List<BatchInterceptor> batchInterceptors;
            switch (this.batchInterceptors == null ? 0 : this.batchInterceptors.size()) {
                case 0: {
                    batchInterceptors = Collections.emptyList();
                    break;
                }
                case 1: {
                    batchInterceptors = Collections.singletonList(this.batchInterceptors.get(0));
                    break;
                }
                default: {
                    batchInterceptors = Collections.unmodifiableList(new ArrayList<BatchInterceptor>(this.batchInterceptors));
                }
            }
            int threads = this.threads;
            if (!this.threads$set) {
                threads = TrackingConfiguration.$default$threads();
            }
            String typeFilter = this.typeFilter;
            if (!this.typeFilter$set) {
                typeFilter = TrackingConfiguration.$default$typeFilter();
            }
            int maxFetchBatchSize = this.maxFetchBatchSize;
            if (!this.maxFetchBatchSize$set) {
                maxFetchBatchSize = TrackingConfiguration.$default$maxFetchBatchSize();
            }
            int maxConsumerBatchSize = this.maxConsumerBatchSize;
            if (!this.maxConsumerBatchSize$set) {
                maxConsumerBatchSize = TrackingConfiguration.$default$maxConsumerBatchSize();
            }
            Duration maxWaitDuration = this.maxWaitDuration;
            if (!this.maxWaitDuration$set) {
                maxWaitDuration = TrackingConfiguration.$default$maxWaitDuration();
            }
            Duration retryDelay = this.retryDelay;
            if (!this.retryDelay$set) {
                retryDelay = TrackingConfiguration.$default$retryDelay();
            }
            boolean ignoreMessageTarget = this.ignoreMessageTarget;
            if (!this.ignoreMessageTarget$set) {
                ignoreMessageTarget = TrackingConfiguration.$default$ignoreMessageTarget();
            }
            TrackingStrategy readStrategy = this.readStrategy;
            if (!this.readStrategy$set) {
                readStrategy = TrackingConfiguration.$default$readStrategy();
            }
            return new TrackingConfiguration(threads, typeFilter, maxFetchBatchSize, maxConsumerBatchSize, maxWaitDuration, retryDelay, batchInterceptors, ignoreMessageTarget, readStrategy);
        }

        public String toString() {
            return "TrackingConfiguration.Builder(threads=" + this.threads + ", typeFilter=" + this.typeFilter + ", maxFetchBatchSize=" + this.maxFetchBatchSize + ", maxConsumerBatchSize=" + this.maxConsumerBatchSize + ", maxWaitDuration=" + this.maxWaitDuration + ", retryDelay=" + this.retryDelay + ", batchInterceptors=" + this.batchInterceptors + ", ignoreMessageTarget=" + this.ignoreMessageTarget + ", readStrategy=" + this.readStrategy + ")";
        }
    }
}

