/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import java.util.function.Consumer;

public interface TransactionManager
extends BatchInterceptor {
    public Transaction startTransaction();

    default public void executeInTransaction(Runnable task) {
        Transaction transaction = this.startTransaction();
        try {
            task.run();
            transaction.commit();
        }
        catch (Throwable e) {
            transaction.rollback();
            throw e;
        }
    }

    @Override
    default public Consumer<MessageBatch> intercept(Consumer<MessageBatch> consumer, Tracker tracker) {
        return messageBatch -> this.executeInTransaction(() -> consumer.accept((MessageBatch)messageBatch));
    }

    public static interface Transaction {
        public void commit();

        public void rollback();
    }
}

