/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.errorreporting;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.common.exception.TechnicalException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.ErrorGateway;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import java.beans.ConstructorProperties;
import java.util.function.Function;

public class ErrorReportingInterceptor
implements HandlerInterceptor {
    private final ErrorGateway errorGateway;

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
        return m -> {
            try {
                return function.apply((DeserializingMessage)m);
            }
            catch (FunctionalException | TechnicalException e) {
                this.reportError(e, (DeserializingMessage)m);
                throw e;
            }
            catch (Exception e) {
                this.reportError(new TechnicalException(String.format("Handler %s failed to handle a %s", handler, m)), (DeserializingMessage)m);
                throw e;
            }
        };
    }

    protected void reportError(Exception e, DeserializingMessage cause) {
        this.errorGateway.report(new Message(e, MessageType.ERROR), cause.getSerializedObject().getSource());
    }

    @ConstructorProperties(value={"errorGateway"})
    public ErrorReportingInterceptor(ErrorGateway errorGateway) {
        this.errorGateway = errorGateway;
    }
}

