/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.validation;

import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import java.beans.ConstructorProperties;
import java.lang.annotation.ElementType;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;

public class ValidationException
extends FunctionalException {
    private final SortedSet<String> violations;

    public ValidationException(Set<? extends ConstraintViolation<?>> violations) {
        super(violations.stream().map(ValidationException::format).collect(Collectors.joining(System.lineSeparator())));
        this.violations = violations.stream().map(ValidationException::format).collect(Collectors.toCollection(TreeSet::new));
    }

    @ConstructorProperties(value={"message", "violations"})
    public ValidationException(String message, Set<String> violations) {
        super(message);
        this.violations = new TreeSet<String>(violations);
    }

    protected static String format(ConstraintViolation<?> v) {
        if (((ConstraintDescriptorImpl)v.getConstraintDescriptor()).getElementType() == ElementType.METHOD) {
            return v.getMessage();
        }
        return String.format("%s %s", v.getPropertyPath(), v.getMessage());
    }

    protected static String format(Set<? extends ConstraintViolation<?>> violations) {
        return violations.stream().map(ValidationException::format).sorted().collect(Collectors.joining(System.lineSeparator()));
    }

    public SortedSet<String> getViolations() {
        return this.violations;
    }
}

