/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.metrics;

import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.metrics.HandleMessageEvent;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerMonitor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HandlerMonitor.class);

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, Handler<DeserializingMessage> handler, String consumer) {
        return message -> {
            Instant start = Instant.now();
            try {
                Object result = function.apply((DeserializingMessage)message);
                this.publishMetrics(handler, consumer, (DeserializingMessage)message, false, start);
                return result;
            }
            catch (Throwable e) {
                this.publishMetrics(handler, consumer, (DeserializingMessage)message, true, start);
                throw e;
            }
        };
    }

    protected void publishMetrics(Object handler, String consumer, DeserializingMessage message, boolean exceptionalResult, Instant start) {
        try {
            long nsDuration = start.until(Instant.now(), ChronoUnit.NANOS);
            FluxCapacitor.publishMetrics(new HandleMessageEvent(FluxCapacitor.get().client().name(), FluxCapacitor.get().client().id(), consumer, handler.getClass().getSimpleName(), message.getPayloadClass().getSimpleName(), exceptionalResult, nsDuration));
        }
        catch (Exception e) {
            log.error("Failed to publish handler metrics", (Throwable)e);
        }
    }
}

