/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.metrics;

import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import io.fluxcapacitor.javaclient.tracking.metrics.ProcessBatchEvent;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerMonitor
implements BatchInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TrackerMonitor.class);

    @Override
    public Consumer<MessageBatch> intercept(Consumer<MessageBatch> consumer, Tracker tracker) {
        return batch -> {
            if (batch.isEmpty()) {
                consumer.accept((MessageBatch)batch);
                return;
            }
            Instant start = Instant.now();
            consumer.accept((MessageBatch)batch);
            long nsDuration = start.until(Instant.now(), ChronoUnit.NANOS);
            try {
                FluxCapacitor.publishMetrics(new ProcessBatchEvent(FluxCapacitor.get().client().name(), FluxCapacitor.get().client().id(), tracker.getName(), tracker.getChannel(), batch.getSize(), nsDuration));
            }
            catch (Exception e) {
                log.error("Failed to publish consumer metrics", (Throwable)e);
            }
        };
    }
}

