/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import io.fusionauth.http.Buildable;
import io.fusionauth.http.util.DateTools;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Cookie
implements Buildable<Cookie> {
    public static final String DomainPrefix = "; Domain=";
    public static final String ExpiresPrefix = "; Expires=";
    public static final String HTTPOnlyPrefix = "; HttpOnly";
    public static final String MaxAgePrefix = "; Max-Age=";
    public static final String PathPrefix = "; Path=";
    public static final String SameSitePrefix = "; SameSite=";
    public static final String SecurePrefix = "; Secure";
    public Map<String, String> attributes = new HashMap<String, String>(0);
    public String domain;
    public ZonedDateTime expires;
    public boolean httpOnly;
    public Long maxAge;
    public String name;
    public String path;
    public SameSite sameSite;
    public boolean secure;
    public String value;

    public Cookie() {
    }

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Cookie(Cookie other) {
        if (other == null) {
            return;
        }
        this.attributes.putAll(other.attributes);
        this.domain = other.domain;
        this.expires = other.expires;
        this.httpOnly = other.httpOnly;
        this.maxAge = other.maxAge;
        this.name = other.name;
        this.path = other.path;
        this.sameSite = other.sameSite;
        this.secure = other.secure;
        this.value = other.value;
    }

    public static List<Cookie> fromRequestHeader(String header) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        boolean inName = false;
        boolean inValue = false;
        char[] chars = header.toCharArray();
        int start = 0;
        String name = null;
        String value = null;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!(inName || inValue || !Character.isWhitespace(c) && c != ';')) {
                ++start;
                continue;
            }
            if (c == '=' && inName) {
                name = new String(chars, start, i - start);
                value = "";
                inValue = true;
                inName = false;
                start = i + 1;
                continue;
            }
            if (c == ';' && inValue) {
                value = new String(chars, start, i - start);
                if (!name.trim().isEmpty() && !value.trim().isEmpty()) {
                    cookies.add(new Cookie(name, value));
                }
                inValue = false;
                name = null;
                value = null;
                start = 0;
                continue;
            }
            if (inName || inValue) continue;
            inName = true;
            start = i;
        }
        if (inName && start > 0) {
            name = header.substring(start);
        }
        if (inValue && start > 0) {
            value = header.substring(start);
        }
        if (name != null && value != null && !name.trim().isEmpty() && !value.trim().isEmpty()) {
            cookies.add(new Cookie(name, value));
        }
        return cookies;
    }

    public static Cookie fromResponseHeader(String header) {
        Cookie cookie = new Cookie();
        boolean inName = false;
        boolean inValue = false;
        boolean inAttributes = false;
        char[] chars = header.toCharArray();
        int start = 0;
        String name = null;
        String value = null;
        for (int i = 0; i < header.length(); ++i) {
            char c = chars[i];
            if (!(inName || inValue || !Character.isWhitespace(c) && c != ';')) {
                ++start;
                continue;
            }
            if (c == '=' && inName) {
                name = header.substring(start, i);
                if (!inAttributes && name.trim().isEmpty()) {
                    return null;
                }
                value = "";
                inValue = true;
                inName = false;
                start = i < header.length() - 1 && chars[i + 1] == '\"' ? i + 2 : i + 1;
                continue;
            }
            if (c == ';') {
                if (inName) {
                    if (!inAttributes) {
                        return null;
                    }
                    name = header.substring(start, i);
                    value = null;
                } else {
                    int end = chars[i - 1] == '\"' ? i - 1 : i;
                    value = header.substring(start, end);
                }
                if (inAttributes) {
                    cookie.addAttribute(name, value);
                } else {
                    cookie.name = name;
                    cookie.value = value;
                }
                inName = false;
                inValue = false;
                inAttributes = true;
                name = null;
                value = null;
                continue;
            }
            if (inName || inValue) continue;
            inName = true;
            start = i;
        }
        if (inName && start > 0) {
            name = header.substring(start);
        }
        if (inValue && start > 0) {
            value = header.substring(start);
        }
        if (inAttributes) {
            cookie.addAttribute(name, value);
        } else {
            if (name == null || value == null || name.trim().isEmpty()) {
                return null;
            }
            cookie.name = name;
            cookie.value = value;
        }
        return cookie;
    }

    public void addAttribute(String name, String value) {
        if (name == null) {
            return;
        }
        switch (name.toLowerCase()) {
            case "domain": {
                this.domain = value;
                break;
            }
            case "expires": {
                this.expires = DateTools.parse(value);
                break;
            }
            case "httponly": {
                this.httpOnly = true;
                break;
            }
            case "max-age": {
                try {
                    this.maxAge = Long.parseLong(value);
                }
                catch (Exception exception) {}
                break;
            }
            case "path": {
                this.path = value;
                break;
            }
            case "samesite": {
                try {
                    this.sameSite = SameSite.valueOf(value);
                }
                catch (Exception exception) {}
                break;
            }
            case "secure": {
                this.secure = true;
            }
            default: {
                this.attributes.put(name, value == null ? "" : value);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie cookie = (Cookie)o;
        return this.httpOnly == cookie.httpOnly && this.secure == cookie.secure && Objects.equals(this.attributes, cookie.attributes) && Objects.equals(this.domain, cookie.domain) && Objects.equals(this.expires, cookie.expires) && Objects.equals(this.maxAge, cookie.maxAge) && Objects.equals(this.name, cookie.name) && Objects.equals(this.path, cookie.path) && this.sameSite == cookie.sameSite && Objects.equals(this.value, cookie.value);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ZonedDateTime getExpires() {
        return this.expires;
    }

    public void setExpires(ZonedDateTime expires) {
        this.expires = expires;
    }

    public Long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Long maxAge) {
        this.maxAge = maxAge;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public SameSite getSameSite() {
        return this.sameSite;
    }

    public void setSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributes, this.domain, this.expires, this.httpOnly, this.maxAge, this.name, this.path, this.sameSite, this.secure, this.value});
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String toRequestHeader() {
        return this.name + "=" + this.value;
    }

    public String toResponseHeader() {
        StringBuilder build = new StringBuilder();
        build.append(this.name).append("=");
        if (this.value != null) {
            build.append(this.value);
        }
        if (this.domain != null) {
            build.append(DomainPrefix).append(this.domain);
        }
        if (this.expires != null) {
            build.append(ExpiresPrefix).append(DateTools.format(this.expires));
        }
        if (this.httpOnly) {
            build.append(HTTPOnlyPrefix);
        }
        if (this.maxAge != null) {
            build.append(MaxAgePrefix).append(this.maxAge);
        }
        if (this.path != null) {
            build.append(PathPrefix).append(this.path);
        }
        if (this.sameSite != null) {
            build.append(SameSitePrefix).append(this.sameSite.name());
        }
        if (this.secure) {
            build.append(SecurePrefix);
        }
        return build.toString();
    }

    public static enum SameSite {
        Lax,
        None,
        Strict;

    }
}

