/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

public final class HTTPValues {
    private HTTPValues() {
    }

    public static final class TransferEncodings {
        public static final String Chunked = "chunked";
        public static final String Compress = "compress";
        public static final String Deflate = "deflate";
        public static final String Gzip = "gzip";

        private TransferEncodings() {
        }
    }

    public static final class Status {
        public static final String ContinueRequest = "100-continue";
        public static final int MovedPermanently = 301;
        public static final int MovedTemporarily = 302;
        public static final int NotModified = 304;

        private Status() {
        }
    }

    public static final class Protocols {
        public static final String HTTTP1_0 = "HTTP/1.0";
        public static final String HTTTP1_1 = "HTTP/1.1";

        private Protocols() {
        }
    }

    public static final class ProtocolBytes {
        public static final byte[] HTTTP1_1 = "HTTP/1.1".getBytes();

        private ProtocolBytes() {
        }
    }

    public static final class Methods {
        public static final String CONNECT = "CONNECT";
        public static final String DELETE = "DELETE";
        public static final String GET = "GET";
        public static final String HEAD = "HEAD";
        public static final String OPTIONS = "OPTIONS";
        public static final String PATCH = "PATCH";
        public static final String POST = "POST";
        public static final String PUT = "PUT";
        public static final String TRACE = "TRACE";

        private Methods() {
        }
    }

    public static final class Headers {
        public static final String AcceptEncoding = "Accept-Encoding";
        public static final String AcceptEncodingLower = "accept-encoding";
        public static final String AcceptLanguage = "Accept-Language";
        public static final String AcceptLanguageLower = "accept-language";
        public static final String AccessControlAllowCredentials = "Access-Control-Allow-Credentials";
        public static final String AccessControlAllowHeaders = "Access-Control-Allow-Headers";
        public static final String AccessControlAllowMethods = "Access-Control-Allow-Methods";
        public static final String AccessControlAllowOrigin = "Access-Control-Allow-Origin";
        public static final String AccessControlExposeHeaders = "Access-Control-Expose-Headers";
        public static final String AccessControlMaxAge = "Access-Control-Max-Age";
        public static final String AccessControlRequestHeaders = "Access-Control-Request-Headers";
        public static final String AccessControlRequestMethod = "Access-Control-Request-Method";
        public static final String CacheControl = "Cache-Control";
        public static final String Connection = "Connection";
        public static final String ContentDispositionLower = "content-disposition";
        public static final String ContentEncoding = "Content-Encoding";
        public static final String ContentLength = "Content-Length";
        public static final String ContentLengthLower = "content-length";
        public static final String ContentType = "Content-Type";
        public static final String ContentTypeLower = "content-type";
        public static final String Cookie = "Cookie";
        public static final String CookieLower = "cookie";
        public static final String Date = "Date";
        public static final String Expect = "Expect";
        public static final String Expires = "Expires";
        public static final String Host = "Host";
        public static final String HostLower = "host";
        public static final String IfModifiedSince = "If-Modified-Since";
        public static final String LastModified = "Last-Modified";
        public static final String Location = "Location";
        public static final String MethodOverride = "X-HTTP-Method-Override";
        public static final String Origin = "Origin";
        public static final String Referer = "Referer";
        public static final String RetryAfter = "Retry-After";
        public static final String SetCookie = "Set-Cookie";
        public static final String TransferEncoding = "Transfer-Encoding";
        public static final String UserAgent = "User-Agent";
        public static final String Vary = "Vary";
        public static final String XForwardedFor = "X-Forwarded-For";
        public static final String XForwardedHost = "X-Forwarded-Host";
        public static final String XForwardedPort = "X-Forwarded-Port";
        public static final String XForwardedProto = "X-Forwarded-Proto";

        private Headers() {
        }
    }

    public static final class HeaderBytes {
        public static final byte[] SetCookie = "Set-Cookie".getBytes();

        private HeaderBytes() {
        }
    }

    public static final class DispositionParameters {
        public static final String filename = "filename";
        public static final String name = "name";
    }

    public static final class CookieAttributes {
        public static final String Domain = "Domain";
        public static final String DomainLower = "domain";
        public static final String Expires = "Expires";
        public static final String ExpiresLower = "expires";
        public static final String HttpOnly = "HttpOnly";
        public static final String HttpOnlyLower = "httponly";
        public static final String MaxAge = "Max-Age";
        public static final String MaxAgeLower = "max-age";
        public static final String Path = "Path";
        public static final String PathLower = "path";
        public static final String SameSite = "SameSite";
        public static final String SameSiteLower = "samesite";
        public static final String Secure = "Secure";
        public static final String SecureLower = "secure";

        private CookieAttributes() {
        }
    }

    public static final class ControlBytes {
        public static final byte CR = 13;
        public static final byte Dash = 45;
        public static final byte LF = 10;
        public static final byte[] CRLF = new byte[]{13, 10};
        public static final byte[] ChunkedTerminator = new byte[]{48, 13, 10, 13, 10};
        public static final byte[] MultipartBoundaryPrefix = new byte[]{13, 10, 45, 45};
        public static final byte[] MultipartTerminator = new byte[]{45, 45};
        public static final byte Zero = 48;
        public static final byte[] MultipartFinalChunkBytes = new byte[]{48, 13, 10, 13, 10};

        private ControlBytes() {
        }
    }

    public static final class ContentTypes {
        public static final String ApplicationJson = "application/json";
        public static final String ApplicationXml = "application/xml";
        public static final String BoundaryParameter = "boundary";
        public static final String CharsetParameter = "charset";
        public static final String Form = "application/x-www-form-urlencoded";
        public static final String MultipartPrefix = "multipart/";
        public static final String Octet = "application/octet-stream";
        public static final String Text = "text/plain";

        private ContentTypes() {
        }
    }

    public static final class ContentEncodings {
        public static final String Deflate = "deflate";
        public static final String Gzip = "gzip";

        private ContentEncodings() {
        }
    }

    public static final class Connections {
        public static final String Close = "close";
        public static final String KeepAlive = "keep-alive";

        private Connections() {
        }
    }

    public static final class CacheControl {
        public static final String NoCache = "no-cache";
        public static final String NoStore = "no-store";
        public static final String OnlyIfCached = "only-if-cached";
    }
}

