/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.io;

import io.fusionauth.http.io.MultipartFileUploadPolicy;
import java.util.Objects;

public class MultipartConfiguration {
    private boolean deleteTemporaryFiles = true;
    private MultipartFileUploadPolicy fileUploadPolicy = MultipartFileUploadPolicy.Reject;
    private long maxFileSize = 0x100000L;
    private long maxRequestSize = 0xA00000L;
    private int multipartBufferSize = 8192;
    private String temporaryFileLocation = System.getProperty("java.io.tmpdir");
    private String temporaryFilenamePrefix = "java-http";
    private String temporaryFilenameSuffix = "file-upload";

    public MultipartConfiguration() {
    }

    public MultipartConfiguration(MultipartConfiguration other) {
        this.deleteTemporaryFiles = other.deleteTemporaryFiles;
        this.fileUploadPolicy = other.fileUploadPolicy;
        this.maxFileSize = other.maxFileSize;
        this.maxRequestSize = other.maxRequestSize;
        this.multipartBufferSize = other.multipartBufferSize;
        this.temporaryFileLocation = other.temporaryFileLocation;
        this.temporaryFilenamePrefix = other.temporaryFilenamePrefix;
        this.temporaryFilenameSuffix = other.temporaryFilenameSuffix;
    }

    public boolean deleteTemporaryFiles() {
        return this.deleteTemporaryFiles;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultipartConfiguration)) {
            return false;
        }
        MultipartConfiguration that = (MultipartConfiguration)o;
        return this.deleteTemporaryFiles == that.deleteTemporaryFiles && this.fileUploadPolicy == that.fileUploadPolicy && this.maxFileSize == that.maxFileSize && this.maxRequestSize == that.maxRequestSize && this.multipartBufferSize == that.multipartBufferSize && Objects.equals(this.temporaryFileLocation, that.temporaryFileLocation) && Objects.equals(this.temporaryFilenamePrefix, that.temporaryFilenamePrefix) && Objects.equals(this.temporaryFilenameSuffix, that.temporaryFilenameSuffix);
    }

    public MultipartFileUploadPolicy getFileUploadPolicy() {
        return this.fileUploadPolicy;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public int getMultipartBufferSize() {
        return this.multipartBufferSize;
    }

    public String getTemporaryFileLocation() {
        return this.temporaryFileLocation;
    }

    public String getTemporaryFilenamePrefix() {
        return this.temporaryFilenamePrefix;
    }

    public String getTemporaryFilenameSuffix() {
        return this.temporaryFilenameSuffix;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deleteTemporaryFiles, this.fileUploadPolicy, this.maxFileSize, this.maxRequestSize, this.multipartBufferSize, this.temporaryFileLocation, this.temporaryFilenamePrefix, this.temporaryFilenameSuffix});
    }

    public boolean isDeleteTemporaryFiles() {
        return this.deleteTemporaryFiles;
    }

    public MultipartConfiguration withDeleteTemporaryFiles(boolean deleteTemporaryFiles) {
        this.deleteTemporaryFiles = deleteTemporaryFiles;
        return this;
    }

    public MultipartConfiguration withFileUploadPolicy(MultipartFileUploadPolicy fileUploadPolicy) {
        Objects.requireNonNull(fileUploadPolicy, "You cannot set the fileUploadPolicy to null");
        this.fileUploadPolicy = fileUploadPolicy;
        return this;
    }

    public MultipartConfiguration withMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    public MultipartConfiguration withMaxRequestSize(long maxRequestSize) {
        if (maxRequestSize < this.maxFileSize) {
            throw new IllegalArgumentException("The maximum request size must be greater than the maxFileSize");
        }
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public MultipartConfiguration withMultipartBufferSize(int multipartBufferSize) {
        if (multipartBufferSize <= 0) {
            throw new IllegalArgumentException("The multipart buffer size must be greater than 0");
        }
        this.multipartBufferSize = multipartBufferSize;
        return this;
    }

    public MultipartConfiguration withTemporaryFileLocation(String temporaryFileLocation) {
        Objects.requireNonNull(temporaryFileLocation, "You cannot set the temporaryFileLocation to null");
        this.temporaryFileLocation = temporaryFileLocation;
        return this;
    }

    public MultipartConfiguration withTemporaryFilenamePrefix(String temporaryFilenamePrefix) {
        this.temporaryFilenamePrefix = temporaryFilenamePrefix;
        return this;
    }

    public MultipartConfiguration withTemporaryFilenameSuffix(String temporaryFilenameSuffix) {
        this.temporaryFilenameSuffix = temporaryFilenameSuffix;
        return this;
    }
}

