/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.server;

import io.fusionauth.http.io.MultipartConfiguration;
import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.server.ExpectValidator;
import io.fusionauth.http.server.HTTPHandler;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPServerConfiguration;
import io.fusionauth.http.server.HTTPUnexpectedExceptionHandler;
import io.fusionauth.http.server.Instrumenter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;

public interface Configurable<T extends Configurable<T>> {
    public HTTPServerConfiguration configuration();

    default public T withBaseDir(Path baseDir) {
        this.configuration().withBaseDir(baseDir);
        return (T)this;
    }

    default public T withChunkedBufferSize(int chunkedBufferSize) {
        this.configuration().withChunkedBufferSize(chunkedBufferSize);
        return (T)this;
    }

    default public T withCompressByDefault(boolean compressByDefault) {
        this.configuration().withCompressByDefault(compressByDefault);
        return (T)this;
    }

    default public T withContextPath(String contextPath) {
        this.configuration().withContextPath(contextPath);
        return (T)this;
    }

    default public T withExpectValidator(ExpectValidator validator) {
        this.configuration().withExpectValidator(validator);
        return (T)this;
    }

    default public T withHandler(HTTPHandler handler) {
        this.configuration().withHandler(handler);
        return (T)this;
    }

    default public T withInitialReadTimeout(Duration duration) {
        this.configuration().withInitialReadTimeout(duration);
        return (T)this;
    }

    default public T withInstrumenter(Instrumenter instrumenter) {
        this.configuration().withInstrumenter(instrumenter);
        return (T)this;
    }

    default public T withKeepAliveTimeoutDuration(Duration duration) {
        this.configuration().withKeepAliveTimeoutDuration(duration);
        return (T)this;
    }

    default public T withListener(HTTPListenerConfiguration listener) {
        this.configuration().withListener(listener);
        return (T)this;
    }

    default public T withLoggerFactory(LoggerFactory loggerFactory) {
        this.configuration().withLoggerFactory(loggerFactory);
        return (T)this;
    }

    default public T withMaxPendingSocketConnections(int maxPendingSocketConnections) {
        this.configuration().withMaxPendingSocketConnections(maxPendingSocketConnections);
        return (T)this;
    }

    default public T withMaxRequestBodySize(Map<String, Integer> maxRequestBodySize) {
        this.configuration().withMaxRequestBodySize((Map)maxRequestBodySize);
        return (T)this;
    }

    default public T withMaxRequestHeaderSize(int maxRequestHeaderSize) {
        this.configuration().withMaxRequestHeaderSize(maxRequestHeaderSize);
        return (T)this;
    }

    default public T withMaxRequestsPerConnection(int maxRequestsPerConnection) {
        this.configuration().withMaxRequestsPerConnection(maxRequestsPerConnection);
        return (T)this;
    }

    default public T withMaxResponseChunkSize(int size) {
        this.configuration().withMaxResponseChunkSize(size);
        return (T)this;
    }

    default public T withMaximumBytesToDrain(int maxBytesToDrain) {
        this.configuration().withMaximumBytesToDrain(maxBytesToDrain);
        return (T)this;
    }

    default public T withMinimumReadThroughput(long bytesPerSecond) {
        this.configuration().withMinimumReadThroughput(bytesPerSecond);
        return (T)this;
    }

    default public T withMinimumWriteThroughput(long bytesPerSecond) {
        this.configuration().withMinimumWriteThroughput(bytesPerSecond);
        return (T)this;
    }

    @Deprecated
    default public T withMultipartBufferSize(int multipartBufferSize) {
        this.configuration().withMultipartBufferSize(multipartBufferSize);
        return (T)this;
    }

    default public T withMultipartConfiguration(MultipartConfiguration multipartStreamConfiguration) {
        this.configuration().withMultipartConfiguration(multipartStreamConfiguration);
        return (T)this;
    }

    default public T withProcessingTimeoutDuration(Duration duration) {
        this.configuration().withProcessingTimeoutDuration(duration);
        return (T)this;
    }

    default public T withReadThroughputCalculationDelayDuration(Duration duration) {
        this.configuration().withReadThroughputCalculationDelayDuration(duration);
        return (T)this;
    }

    default public T withRequestBufferSize(int requestBufferSize) {
        this.configuration().withRequestBufferSize(requestBufferSize);
        return (T)this;
    }

    default public T withResponseBufferSize(int responseBufferSize) {
        this.configuration().withResponseBufferSize(responseBufferSize);
        return (T)this;
    }

    default public T withShutdownDuration(Duration duration) {
        this.configuration().withShutdownDuration(duration);
        return (T)this;
    }

    default public T withUnexpectedExceptionHandler(HTTPUnexpectedExceptionHandler unexpectedExceptionHandler) {
        this.configuration().withUnexpectedExceptionHandler(unexpectedExceptionHandler);
        return (T)this;
    }

    default public T withWriteThroughputCalculationDelayDuration(Duration duration) {
        this.configuration().withWriteThroughputCalculationDelayDuration(duration);
        return (T)this;
    }
}

