/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http.util;

import io.fusionauth.http.Cookie;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.HTTPValues;
import io.fusionauth.http.ParseException;
import io.fusionauth.http.RequestHeadersTooLargeException;
import io.fusionauth.http.io.PushbackInputStream;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.io.ConnectionClosedException;
import io.fusionauth.http.util.RequestPreambleState;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class HTTPTools {
    private static Logger logger;

    public static int getMaxRequestBodySize(String contentType, Map<String, Integer> maxRequestBodySize) {
        if (contentType == null) {
            return maxRequestBodySize.get("*");
        }
        Integer maximumSize = maxRequestBodySize.get(contentType);
        if (maximumSize != null) {
            return maximumSize;
        }
        int index = contentType.indexOf(47);
        if (index != -1) {
            maximumSize = maxRequestBodySize.get(contentType.substring(0, index) + "/*");
        }
        return maximumSize != null ? maximumSize : maxRequestBodySize.get("*");
    }

    public static void initialize(LoggerFactory loggerFactory) {
        logger = loggerFactory.getLogger(HTTPTools.class);
    }

    public static boolean isControlCharacter(byte ch) {
        return ch >= 0 && ch <= 31;
    }

    public static boolean isDigitCharacter(byte ch) {
        return ch >= 48 && ch <= 57;
    }

    public static boolean isHexadecimalCharacter(byte ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    public static boolean isTokenCharacter(byte ch) {
        return ch == 33 || ch == 35 || ch == 36 || ch == 37 || ch == 38 || ch == 39 || ch == 42 || ch == 43 || ch == 45 || ch == 46 || ch == 94 || ch == 95 || ch == 96 || ch == 124 || ch == 126 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57;
    }

    public static boolean isURICharacter(byte ch) {
        return ch >= 33 && ch <= 126;
    }

    public static boolean isValueCharacter(byte ch) {
        int intVal = ch & 0xFF;
        return HTTPTools.isURICharacter(ch) || intVal == 32 || intVal == 9 || intVal == 10 || intVal >= 128;
    }

    public static ParseException makeParseException(byte b, Enum<? extends Enum<?>> state) {
        String hex = HexFormat.of().withUpperCase().formatHex(new byte[]{b});
        String message = HTTPTools.isControlCharacter(b) ? "Unexpected character. Dec [" + b + "] Hex [" + hex + "]" : "Unexpected character. Dec [" + b + "] Hex [" + hex + "] Symbol [" + (char)b + "]";
        return new ParseException(message + " Parse state [" + String.valueOf(state) + "]", state.name());
    }

    public static void parseEncodedData(byte[] data, int start, int length, Charset charset, Map<String, List<String>> result) {
        String value;
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        boolean inName = true;
        String name = null;
        for (int i = start; i < length; ++i) {
            if (data[i] == 61 && inName) {
                if (i == start) {
                    ++start;
                    continue;
                }
                inName = false;
                try {
                    name = URLDecoder.decode(new String(data, start, i - start, charset), charset);
                }
                catch (Exception e) {
                    name = null;
                }
                start = i + 1;
                continue;
            }
            if (data[i] != 38 || inName) continue;
            inName = true;
            if (name == null || start > i) continue;
            try {
                value = start < i ? URLDecoder.decode(new String(data, start, i - start, charset), charset) : "";
                result.computeIfAbsent(name, key -> new LinkedList()).add(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            start = i + 1;
            name = null;
        }
        if (name != null && !inName) {
            try {
                value = start < length ? URLDecoder.decode(new String(data, start, length - start, charset), charset) : "";
                result.computeIfAbsent(name, key -> new LinkedList()).add(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void parseEncodedData(byte[] data, int start, int length, Map<String, List<String>> result) {
        HTTPTools.parseEncodedData(data, start, length, StandardCharsets.UTF_8, result);
    }

    public static HeaderValue parseHeaderValue(String value) {
        String headerValue = null;
        Map<String, String> parameters = null;
        char[] chars = value.toCharArray();
        boolean inQuote = false;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!inQuote && c == ';') {
                if (headerValue == null) {
                    headerValue = new String(chars, start, i - start);
                } else {
                    if (parameters == null) {
                        parameters = new HashMap<String, String>();
                    }
                    HTTPTools.parseHeaderParameter(chars, start, i, parameters);
                }
                start = -1;
                continue;
            }
            if (!inQuote && !Character.isWhitespace(c) && start == -1) {
                start = i;
                continue;
            }
            if (!inQuote && c == '\"') {
                inQuote = true;
                continue;
            }
            if (inQuote && c == '\\' && i < chars.length - 2 && chars[i + 1] == '\"') {
                ++i;
                continue;
            }
            if (!inQuote || c != '\"') continue;
            inQuote = false;
        }
        if (start != -1) {
            if (headerValue == null) {
                headerValue = new String(chars, start, chars.length - start);
            } else {
                if (parameters == null) {
                    parameters = new HashMap<String, String>();
                }
                HTTPTools.parseHeaderParameter(chars, start, chars.length, parameters);
            }
        }
        if (parameters == null) {
            parameters = Map.of();
        }
        return new HeaderValue(headerValue, parameters);
    }

    public static void parseRequestPreamble(PushbackInputStream inputStream, int maxRequestHeaderSize, HTTPRequest request, byte[] requestBuffer, Runnable readObserver) throws IOException {
        RequestPreambleState state = RequestPreambleState.RequestMethod;
        ByteArrayOutputStream valueBuffer = new ByteArrayOutputStream(512);
        String headerName = null;
        int read = 0;
        int index = 0;
        int premableLength = 0;
        while (state != RequestPreambleState.Complete) {
            long start = System.currentTimeMillis();
            read = inputStream.read(requestBuffer);
            if (read < 0) {
                long waited = System.currentTimeMillis() - start;
                throw new ConnectionClosedException(String.format("Read returned [%d] after waiting [%d] ms", read, waited));
            }
            logger.trace("Read [{}] from client for preamble.", read);
            if (premableLength == 0) {
                readObserver.run();
            }
            for (index = 0; index < read && state != RequestPreambleState.Complete; ++index) {
                byte ch = requestBuffer[index];
                RequestPreambleState nextState = state.next(ch);
                if (nextState != state) {
                    switch (state) {
                        case RequestMethod: {
                            request.setMethod(HTTPMethod.of(valueBuffer.toString(StandardCharsets.UTF_8)));
                            break;
                        }
                        case RequestPath: {
                            request.setPath(valueBuffer.toString(StandardCharsets.UTF_8));
                            break;
                        }
                        case RequestProtocol: {
                            request.setProtocol(valueBuffer.toString(StandardCharsets.UTF_8));
                            break;
                        }
                        case HeaderName: {
                            headerName = valueBuffer.toString(StandardCharsets.UTF_8);
                            break;
                        }
                        case HeaderValue: {
                            request.addHeader(headerName, valueBuffer.toString(StandardCharsets.UTF_8));
                        }
                    }
                    if (nextState.store()) {
                        valueBuffer.reset();
                        valueBuffer.write(ch);
                    }
                } else if (state.store()) {
                    valueBuffer.write(ch);
                }
                state = nextState;
            }
            if (maxRequestHeaderSize == -1 || (premableLength += index) <= maxRequestHeaderSize) continue;
            throw new RequestHeadersTooLargeException((long)maxRequestHeaderSize, "The maximum size of the request header has been exceeded. The maximum size is [" + maxRequestHeaderSize + "] bytes.");
        }
        if (index < read) {
            inputStream.push(requestBuffer, index, read - index);
        }
    }

    public static void writeResponsePreamble(HTTPResponse response, OutputStream outputStream) throws IOException {
        HTTPTools.writeStatusLine(response, outputStream);
        for (Map.Entry<String, List<String>> headers : response.getHeadersMap().entrySet()) {
            String name = headers.getKey();
            for (String value : headers.getValue()) {
                outputStream.write(name.getBytes());
                outputStream.write(58);
                outputStream.write(32);
                outputStream.write(value.getBytes());
                outputStream.write(HTTPValues.ControlBytes.CRLF);
            }
        }
        for (Cookie cookie : response.getCookies()) {
            outputStream.write(HTTPValues.HeaderBytes.SetCookie);
            outputStream.write(58);
            outputStream.write(32);
            outputStream.write(cookie.toResponseHeader().getBytes());
            outputStream.write(HTTPValues.ControlBytes.CRLF);
        }
        outputStream.write(HTTPValues.ControlBytes.CRLF);
    }

    private static void parseHeaderParameter(char[] chars, int start, int end, Map<String, String> parameters) {
        boolean encoded = false;
        Charset charset = null;
        String name = null;
        for (int i = start; i < end; ++i) {
            if (name == null && chars[i] == '*') {
                encoded = true;
                name = new String(chars, start, i - start).toLowerCase();
                start = i + 2;
                continue;
            }
            if (name == null && chars[i] == '=') {
                name = new String(chars, start, i - start).toLowerCase();
                start = i + 1;
                continue;
            }
            if (name != null && encoded && charset == null && chars[i] == '\'') {
                String charsetName = new String(chars, start, i - start);
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (IllegalCharsetNameException e) {
                    charset = StandardCharsets.UTF_8;
                }
                start = i + 1;
                continue;
            }
            if (name == null || !encoded || charset == null || chars[i] != '\'') continue;
            start = i + 1;
        }
        if (start >= end) {
            if (name != null) {
                parameters.put(name, "");
            }
            return;
        }
        if (chars[start] == '\"') {
            ++start;
        }
        if (chars[end - 1] == '\"') {
            --end;
        }
        String encodedValue = new String(chars, start, end - start);
        String value = URLDecoder.decode(encodedValue, Objects.requireNonNullElse(charset, StandardCharsets.UTF_8));
        if (name == null) {
            name = value;
            value = "";
        }
        if (!parameters.containsKey(name) || encoded) {
            parameters.put(name, value);
        }
    }

    private static void writeStatusLine(HTTPResponse response, OutputStream out) throws IOException {
        out.write(HTTPValues.ProtocolBytes.HTTTP1_1);
        out.write(32);
        out.write(Integer.toString(response.getStatus()).getBytes());
        out.write(32);
        if (response.getStatusMessage() != null) {
            out.write(response.getStatusMessage().getBytes());
        }
        out.write(HTTPValues.ControlBytes.CRLF);
    }

    public record HeaderValue(String value, Map<String, String> parameters) {
    }
}

