/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.exceptions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.core.exceptions.StreamException;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class StreamAPIException
extends StreamException {
    private final int errorCode;
    private final int statusCode;
    private final String errorName;

    @JsonCreator
    public StreamAPIException(@JsonProperty(value="detail") String message, @JsonProperty(value="code") int errorCode, @JsonProperty(value="status_code") int statusCode, @JsonProperty(value="exception") String errorName) {
        super(StreamAPIException.formatMessage(message, errorName, errorCode, statusCode));
        this.errorCode = errorCode;
        this.statusCode = statusCode;
        this.errorName = errorName;
    }

    private static String formatMessage(String message, String errorName, int errorCode, int statusCode) {
        StringBuilder result = new StringBuilder();
        if (errorName != null && !errorName.isEmpty()) {
            result.append(errorName);
        }
        if (message != null && !message.isEmpty()) {
            if (result.length() > 0) {
                result.append(": ");
            }
            result.append(message);
        }
        if (result.length() > 0) {
            result.append(" ");
        }
        result.append("(code = ");
        result.append(errorCode);
        result.append(" status = ");
        result.append(statusCode);
        result.append(')');
        return result.toString();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorName() {
        return this.errorName;
    }
}

