/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.cloud;

import io.getstream.cloud.CloudCollectionsClient$$Lambda$1;
import io.getstream.cloud.CloudCollectionsClient$$Lambda$2;
import io.getstream.cloud.CloudCollectionsClient$$Lambda$3;
import io.getstream.core.StreamCollections;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.Token;
import io.getstream.core.models.CollectionData;
import io.getstream.core.utils.Serialization;
import java8.util.concurrent.CompletableFuture;

public final class CloudCollectionsClient {
    private final Token token;
    private final String userID;
    private final StreamCollections collections;

    CloudCollectionsClient(Token token, String userID, StreamCollections collections) {
        this.token = token;
        this.userID = userID;
        this.collections = collections;
    }

    public <T> CompletableFuture<T> addCustom(String collection, T item) throws StreamException {
        return this.addCustom(this.userID, collection, item);
    }

    public <T> CompletableFuture<T> addCustom(String userID, String collection, T item) throws StreamException {
        return this.add(userID, collection, Serialization.convert(item, CollectionData.class)).thenApply(CloudCollectionsClient$$Lambda$1.lambdaFactory$(item));
    }

    public CompletableFuture<CollectionData> add(String collection, CollectionData item) throws StreamException {
        return this.add(this.userID, collection, item);
    }

    public CompletableFuture<CollectionData> add(String userID, String collection, CollectionData item) throws StreamException {
        return this.collections.add(this.token, userID, collection, item);
    }

    public <T> CompletableFuture<T> updateCustom(String collection, T item) throws StreamException {
        return this.updateCustom(this.userID, collection, item);
    }

    public <T> CompletableFuture<T> updateCustom(String userID, String collection, T item) throws StreamException {
        return this.update(userID, collection, Serialization.convert(item, CollectionData.class)).thenApply(CloudCollectionsClient$$Lambda$2.lambdaFactory$(item));
    }

    public CompletableFuture<CollectionData> update(String collection, CollectionData item) throws StreamException {
        return this.update(this.userID, collection, item);
    }

    public CompletableFuture<CollectionData> update(String userID, String collection, CollectionData item) throws StreamException {
        return this.collections.update(this.token, userID, collection, item);
    }

    public <T> CompletableFuture<T> getCustom(Class<T> type, String collection, String id) throws StreamException {
        return this.get(collection, id).thenApply(CloudCollectionsClient$$Lambda$3.lambdaFactory$(type));
    }

    public CompletableFuture<CollectionData> get(String collection, String id) throws StreamException {
        return this.collections.get(this.token, collection, id);
    }

    public CompletableFuture<Void> delete(String collection, String id) throws StreamException {
        return this.collections.delete(this.token, collection, id);
    }

    static /* synthetic */ Object lambda$getCustom$2(Class type, CollectionData data) {
        return Serialization.convert(data, type);
    }

    static /* synthetic */ Object lambda$updateCustom$1(Object item, CollectionData data) {
        return Serialization.convert(data, item.getClass());
    }

    static /* synthetic */ Object lambda$addCustom$0(Object item, CollectionData data) {
        return Serialization.convert(data, item.getClass());
    }
}

