/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.google.common.base.MoreObjects;
import io.getstream.core.http.Token;
import io.getstream.core.models.FeedID;
import java.util.Date;

public final class Auth {
    private Auth() {
    }

    public static Token buildFeedToken(String secret, FeedID feed, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.FEED, action, feed.getSlug() + feed.getUserID());
    }

    public static Token buildToTargetUpdateToken(String secret, FeedID feed, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.FEED_TARGETS, action, feed.getSlug() + feed.getUserID());
    }

    public static Token buildFeedToken(String secret, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.FEED, action, "*");
    }

    public static Token buildActivityToken(String secret, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.ACTIVITIES, action, "*");
    }

    public static Token buildFollowToken(String secret, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.FOLLOWER, action, "*");
    }

    public static Token buildFollowToken(String secret, FeedID feed, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.FOLLOWER, action, feed.getSlug() + feed.getUserID());
    }

    public static Token buildCollectionsToken(String secret, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.COLLECTIONS, action, "*");
    }

    public static Token buildPersonalizationToken(String secret, String userID, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.PERSONALIZATION, action, "*", (String)MoreObjects.firstNonNull((Object)userID, (Object)"*"));
    }

    public static Token buildReactionsToken(String secret, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.REACTIONS, action, "*");
    }

    public static Token buildAnalyticsToken(String secret, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.ANALYTICS, action, "*");
    }

    public static Token buildAnalyticsRedirectToken(String secret) {
        return Auth.buildBackendToken(secret, TokenResource.ANALYTICS_REDIRECT, TokenAction.ANY, "*");
    }

    public static Token buildUsersToken(String secret, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.USERS, action, "*");
    }

    public static Token buildOpenGraphToken(String secret) {
        return Auth.buildBackendToken(secret, TokenResource.OPEN_GRAPH, TokenAction.READ, "*");
    }

    public static Token buildFilesToken(String secret, TokenAction action) {
        return Auth.buildBackendToken(secret, TokenResource.FILES, action, "*");
    }

    public static Token buildFrontendToken(String secret, String userID) {
        return Auth.buildFrontendToken(secret, userID, null);
    }

    public static Token buildFrontendToken(String secret, String userID, Date expiresAt) {
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        JWTCreator.Builder builder = JWT.create().withClaim("user_id", userID);
        if (expiresAt != null) {
            builder = builder.withExpiresAt(expiresAt);
        }
        return new Token(builder.sign(algorithm));
    }

    public static Token buildBackendToken(String secret, TokenResource resource, TokenAction action, String feedID) {
        return Auth.buildBackendToken(secret, resource, action, feedID, null);
    }

    public static Token buildBackendToken(String secret, TokenResource resource, TokenAction action, String feedID, String userID) {
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        JWTCreator.Builder builder = JWT.create();
        builder.withClaim("resource", resource.toString());
        builder.withClaim("action", action.toString());
        builder.withClaim("feed_id", feedID);
        if (userID != null) {
            builder.withClaim("user_id", userID);
        }
        return new Token(builder.sign(algorithm));
    }

    public static enum TokenResource {
        ANY("*"),
        ACTIVITIES("activities"),
        ANALYTICS("analytics"),
        ANALYTICS_REDIRECT("redirect_and_track"),
        COLLECTIONS("collections"),
        FILES("files"),
        FEED("feed"),
        FEED_TARGETS("feed_targets"),
        FOLLOWER("follower"),
        OPEN_GRAPH("url"),
        PERSONALIZATION("personalization"),
        REACTIONS("reactions"),
        USERS("users");

        private final String resource;

        private TokenResource(String resource) {
            this.resource = resource;
        }

        public String toString() {
            return this.resource;
        }
    }

    public static enum TokenAction {
        ANY("*"),
        READ("read"),
        WRITE("write"),
        DELETE("delete");

        private final String action;

        private TokenAction(String action) {
            this.action = action;
        }

        public String toString() {
            return this.action;
        }
    }
}

