/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import io.getstream.client.Client;
import io.getstream.client.Feed;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.models.Activity;
import io.getstream.core.models.EnrichedActivity;
import io.getstream.core.models.FeedID;
import io.getstream.core.options.EnrichmentFlags;
import io.getstream.core.options.Filter;
import io.getstream.core.options.Limit;
import io.getstream.core.options.Offset;
import io.getstream.core.options.Ranking;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.DefaultOptions;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.util.List;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;

public final class FlatFeed
extends Feed {
    FlatFeed(Client client, FeedID id) {
        super(client, id);
    }

    public CompletableFuture<List<Activity>> getActivities() throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, null);
    }

    public CompletableFuture<List<Activity>> getActivities(Limit limit) throws StreamException {
        return this.getActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, null);
    }

    public CompletableFuture<List<Activity>> getActivities(String ranking) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public CompletableFuture<List<Activity>> getActivities(Filter filter) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, null);
    }

    public CompletableFuture<List<Activity>> getActivities(Offset offset) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, null);
    }

    public CompletableFuture<List<Activity>> getActivities(Limit limit, String ranking) throws StreamException {
        return this.getActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public CompletableFuture<List<Activity>> getActivities(Limit limit, Filter filter) throws StreamException {
        return this.getActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, null);
    }

    public CompletableFuture<List<Activity>> getActivities(Limit limit, Offset offset) throws StreamException {
        return this.getActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, null);
    }

    public CompletableFuture<List<Activity>> getActivities(Filter filter, String ranking) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, ranking);
    }

    public CompletableFuture<List<Activity>> getActivities(Offset offset, String ranking) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public CompletableFuture<List<Activity>> getActivities(Limit limit, Filter filter, String ranking) throws StreamException {
        return this.getActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, ranking);
    }

    public CompletableFuture<List<Activity>> getActivities(Limit limit, Offset offset, String ranking) throws StreamException {
        return this.getActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    CompletableFuture<List<Activity>> getActivities(Limit limit, Offset offset, Filter filter, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[4];
            requestOptionArray2[0] = limit;
            requestOptionArray2[1] = offset;
            requestOptionArray2[2] = filter;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[3] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[5];
            requestOptionArray3[0] = limit;
            requestOptionArray3[1] = offset;
            requestOptionArray3[2] = filter;
            requestOptionArray3[3] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[4] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, Activity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Limit limit) throws StreamException {
        return this.getCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, String ranking) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Offset offset) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Limit limit, String ranking) throws StreamException {
        return this.getCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Limit limit, Filter filter) throws StreamException {
        return this.getCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Limit limit, Offset offset) throws StreamException {
        return this.getCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, null);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Offset offset, String ranking) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Filter filter, String ranking) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, ranking);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Limit limit, Offset offset, String ranking) throws StreamException {
        return this.getCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, ranking);
    }

    public <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Limit limit, Filter filter, String ranking) throws StreamException {
        return this.getCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, ranking);
    }

    <T> CompletableFuture<List<T>> getCustomActivities(Class<T> type, Limit limit, Offset offset, Filter filter, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[4];
            requestOptionArray2[0] = limit;
            requestOptionArray2[1] = offset;
            requestOptionArray2[2] = filter;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[3] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[5];
            requestOptionArray3[0] = limit;
            requestOptionArray3[1] = offset;
            requestOptionArray3[2] = filter;
            requestOptionArray3[3] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[4] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, type);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities() throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, String ranking) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, Filter filter) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Offset offset) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, Offset offset) throws StreamException {
        return this.getEnrichedActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Offset offset, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, Offset offset, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, Filter filter, String ranking) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, flags, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(limit, DefaultOptions.DEFAULT_OFFSET, filter, flags, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Offset offset, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, Offset offset, String ranking) throws StreamException {
        return this.getEnrichedActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Offset offset, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, Offset offset, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedActivities(limit, offset, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    CompletableFuture<List<EnrichedActivity>> getEnrichedActivities(Limit limit, Offset offset, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[5];
            requestOptionArray2[0] = limit;
            requestOptionArray2[1] = offset;
            requestOptionArray2[2] = filter;
            requestOptionArray2[3] = flags;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[4] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[6];
            requestOptionArray3[0] = limit;
            requestOptionArray3[1] = offset;
            requestOptionArray3[2] = filter;
            requestOptionArray3[3] = flags;
            requestOptionArray3[4] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[5] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getEnrichedActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, EnrichedActivity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Filter filter) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Filter filter, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Offset offset) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Offset offset) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Offset offset, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Offset offset, EnrichmentFlags flags) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, flags, null);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Offset offset, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Offset offset, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Offset offset, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, offset, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Offset offset, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, offset, DefaultOptions.DEFAULT_FILTER, flags, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Filter filter, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, DefaultOptions.DEFAULT_ENRICHMENT_FLAGS, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, filter, flags, ranking);
    }

    public <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        return this.getEnrichedCustomActivities(type, limit, DefaultOptions.DEFAULT_OFFSET, filter, flags, ranking);
    }

    <T> CompletableFuture<List<T>> getEnrichedCustomActivities(Class<T> type, Limit limit, Offset offset, Filter filter, EnrichmentFlags flags, String ranking) throws StreamException {
        RequestOption[] requestOptionArray;
        if (ranking == null) {
            RequestOption[] requestOptionArray2 = new RequestOption[5];
            requestOptionArray2[0] = limit;
            requestOptionArray2[1] = offset;
            requestOptionArray2[2] = filter;
            requestOptionArray2[3] = flags;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[4] = DefaultOptions.DEFAULT_MARKER;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[6];
            requestOptionArray3[0] = limit;
            requestOptionArray3[1] = offset;
            requestOptionArray3[2] = filter;
            requestOptionArray3[3] = flags;
            requestOptionArray3[4] = DefaultOptions.DEFAULT_MARKER;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[5] = new Ranking(ranking);
        }
        RequestOption[] options = requestOptionArray;
        return this.getClient().getActivities(this.getID(), options).thenApply(response -> {
            try {
                return Serialization.deserializeContainer(response, type);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException((Throwable)e);
            }
        });
    }
}

