/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.variable;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.model.IGs2Credential;
import io.gs2.variable.control.DeleteMyVariableRequest;
import io.gs2.variable.control.DeleteVariableRequest;
import io.gs2.variable.control.GetMyVariableRequest;
import io.gs2.variable.control.GetMyVariableResult;
import io.gs2.variable.control.GetVariableRequest;
import io.gs2.variable.control.GetVariableResult;
import io.gs2.variable.control.SetMyVariableRequest;
import io.gs2.variable.control.SetMyVariableResult;
import io.gs2.variable.control.SetVariableRequest;
import io.gs2.variable.control.SetVariableResult;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;

public class Gs2VariableClient
extends AbstractGs2Client<Gs2VariableClient> {
    public static String ENDPOINT = "variable";

    public Gs2VariableClient(IGs2Credential credential) {
        super(credential);
    }

    public void deleteMyVariable(DeleteMyVariableRequest request) {
        String url = "https://{service}.{region}.gs2io.com/variable/" + (request.getVariableName() == null || request.getVariableName().equals("") ? "null" : request.getVariableName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Variable", "DeleteMyVariable");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        delete.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        this.doRequest((HttpUriRequest)delete, null);
    }

    public void deleteVariable(DeleteVariableRequest request) {
        String url = "https://{service}.{region}.gs2io.com/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "/variable/" + (request.getVariableName() == null || request.getVariableName().equals("") ? "null" : request.getVariableName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Variable", "DeleteVariable");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public GetMyVariableResult getMyVariable(GetMyVariableRequest request) {
        String url = "https://{service}.{region}.gs2io.com/variable/" + (request.getVariableName() == null || request.getVariableName().equals("") ? "null" : request.getVariableName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Variable", "GetMyVariable");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (GetMyVariableResult)this.doRequest((HttpUriRequest)get, GetMyVariableResult.class);
    }

    public GetVariableResult getVariable(GetVariableRequest request) {
        String url = "https://{service}.{region}.gs2io.com/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "/variable/" + (request.getVariableName() == null || request.getVariableName().equals("") ? "null" : request.getVariableName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Variable", "GetVariable");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetVariableResult)this.doRequest((HttpUriRequest)get, GetVariableResult.class);
    }

    public SetMyVariableResult setMyVariable(SetMyVariableRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue()).put("ttl", request.getTtl());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2io.com/variable/" + (request.getVariableName() == null || request.getVariableName().equals("") ? "null" : request.getVariableName()) + "", this.credential, ENDPOINT, "Gs2Variable", "SetMyVariable", body.toString());
        if (request.getRequestId() != null) {
            put.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        put.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (SetMyVariableResult)this.doRequest((HttpUriRequest)put, SetMyVariableResult.class);
    }

    public SetVariableResult setVariable(SetVariableRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue()).put("ttl", request.getTtl());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2io.com/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "/variable/" + (request.getVariableName() == null || request.getVariableName().equals("") ? "null" : request.getVariableName()) + "", this.credential, ENDPOINT, "Gs2Variable", "SetVariable", body.toString());
        if (request.getRequestId() != null) {
            put.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (SetVariableResult)this.doRequest((HttpUriRequest)put, SetVariableResult.class);
    }
}

