/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.declaration.processor;

import io.immutables.declaration.http.DELETE;
import io.immutables.declaration.http.GET;
import io.immutables.declaration.http.OPTIONS;
import io.immutables.declaration.http.PATCH;
import io.immutables.declaration.http.POST;
import io.immutables.declaration.http.PUT;
import io.immutables.declaration.http.Path;
import io.immutables.declaration.http.Status;
import io.immutables.declaration.processor.DatatypeIntrospector;
import io.immutables.declaration.processor.Declaration;
import io.immutables.declaration.processor.KnownAnnotations;
import io.immutables.declaration.processor.PathTemplate;
import io.immutables.declaration.processor.Type;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class ContractIntrospector {
    private final ProcessingEnvironment processing;
    private final Elements elements;
    private final Types types;
    private final DatatypeIntrospector datatypes;
    private final Map<AnnotatedConstruct, KnownAnnotations> annotationsCache;
    public static final String TYPE_RETURNS = "io.immutables.declaration.http.Returns";

    ContractIntrospector(ProcessingEnvironment processing, DatatypeIntrospector datatypes, Map<AnnotatedConstruct, KnownAnnotations> annotationsCache) {
        this.processing = processing;
        this.elements = processing.getElementUtils();
        this.types = processing.getTypeUtils();
        this.datatypes = datatypes;
        this.annotationsCache = annotationsCache;
    }

    Optional<Declaration.Contract> introspect(TypeElement type) {
        String name = type.getSimpleName().toString();
        assert (type.getKind() == ElementKind.INTERFACE);
        if (!type.getTypeParameters().isEmpty()) {
            this.error("Contract '%s' cannot have type parameters".formatted(name), type);
            return Optional.empty();
        }
        if (type.getNestingKind() != NestingKind.TOP_LEVEL) {
            this.error("Contract '%s' cannot be a member type".formatted(name), type);
            return Optional.empty();
        }
        KnownAnnotations contractAnnotations = this.knownAnnotationsOf(type);
        Path path = contractAnnotations.get(Path.class);
        String pathPrefix = path != null ? path.value() : "";
        Declaration.Contract contract = new Declaration.Contract(Declaration.Contract.Tag.Is, this.datatypes.reference(type), pathPrefix, this.extractOperations(type, pathPrefix), this.commentOf(type));
        String qualifiedName = type.getQualifiedName().toString();
        return Optional.of((Declaration.Contract)this.datatypes.declarations.computeIfAbsent(qualifiedName, q -> contract));
    }

    private KnownAnnotations knownAnnotationsOf(AnnotatedConstruct type) {
        return this.annotationsCache.computeIfAbsent(type, KnownAnnotations::from);
    }

    private void error(String message, Element element) {
        this.processing.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private Map<String, Declaration.Operation> extractOperations(TypeElement type, String pathPrefix) {
        List<ExecutableElement> allMethods = List.copyOf(ElementFilter.methodsIn(this.elements.getAllMembers(type)));
        DeclaredType declaringType = (DeclaredType)type.asType();
        LinkedHashMap<String, Declaration.Operation> operations = new LinkedHashMap<String, Declaration.Operation>(allMethods.size());
        for (ExecutableElement method : allMethods) {
            String name = method.getSimpleName().toString();
            if (((TypeElement)method.getEnclosingElement()).getQualifiedName().contentEquals(Object.class.getName())) continue;
            ExecutableType mirror = (ExecutableType)this.types.asMemberOf(declaringType, method);
            Set<Modifier> modifiers = method.getModifiers();
            if (modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.NATIVE)) continue;
            boolean assumedValid = true;
            if (method.isDefault()) {
                this.error("Default methods not supported: '%s'".formatted(name), method);
                assumedValid = false;
            }
            if (!method.getTypeParameters().isEmpty()) {
                this.error("Operation cannot have type parameters: '%s'".formatted(name), method);
                assumedValid = false;
            }
            if (operations.containsKey(name)) {
                this.error("Duplicate (overloaded) operations not allowed: '%s'".formatted(name), method);
                assumedValid = false;
            }
            if (!assumedValid) continue;
            KnownAnnotations annotations = this.knownAnnotationsOf(method);
            HttpBinding binding = this.extractHttpBinding(annotations, method, pathPrefix);
            Declaration.Return returns = this.extractReturn(method, mirror);
            List<Declaration.Thrown> thrown = this.extractThrown(mirror);
            ArrayList collectedParameters = new ArrayList();
            ArrayList collectedFixedQuery = new ArrayList();
            this.collectParameters(method, mirror, binding, collectedParameters::add, collectedFixedQuery::add);
            operations.put(name, new Declaration.Operation(name, binding.template, binding.method, returns, thrown, List.copyOf(collectedParameters), List.copyOf(collectedFixedQuery), this.commentOf(method)));
        }
        return Collections.unmodifiableMap(operations);
    }

    private void collectParameters(ExecutableElement method, ExecutableType mirror, HttpBinding binding, Consumer<Declaration.Parameter> collectParameters, Consumer<Declaration.FixedQuery> collectFixedQuery) {
        HashSet<String> mappedParameterNames = new HashSet<String>();
        Map<String, PathTemplate.Parameter> uriParameters = binding.template.parameters;
        List<? extends TypeMirror> parameterTypes = mirror.getParameterTypes();
        int i = 0;
        boolean hasBodyParameter = false;
        for (VariableElement variableElement : method.getParameters()) {
            String httpName;
            Declaration.Parameter.Mapping mapping;
            int index = i++;
            String name = variableElement.getSimpleName().toString();
            PathTemplate.Parameter uriParameter = uriParameters.get(name);
            if (uriParameter != null) {
                mappedParameterNames.add(name);
                mapping = switch (uriParameter.kind()) {
                    default -> throw new IncompatibleClassChangeError();
                    case PathTemplate.Parameter.Kind.Path -> Declaration.Parameter.Mapping.Path;
                    case PathTemplate.Parameter.Kind.Query -> Declaration.Parameter.Mapping.Query;
                };
                httpName = uriParameter.httpName();
            } else {
                if (!hasBodyParameter) {
                    mappedParameterNames.add(name);
                    hasBodyParameter = true;
                    mapping = Declaration.Parameter.Mapping.Body;
                } else {
                    this.error("Unmapped parameter '%s', cannot have more than one request body".formatted(name), variableElement);
                    mapping = Declaration.Parameter.Mapping.Unmapped;
                }
                httpName = "";
            }
            Type.Mirror type = new Type.Mirror(parameterTypes.get(index));
            collectParameters.accept(new Declaration.Parameter(name, httpName, index, type, mapping, this.commentOf(variableElement)));
        }
        for (String string : uriParameters.keySet()) {
            if (mappedParameterNames.contains(string)) continue;
            PathTemplate.Parameter leftover = uriParameters.get(string);
            collectFixedQuery.accept(new Declaration.FixedQuery(leftover.httpName(), leftover.value()));
        }
    }

    private List<Declaration.Thrown> extractThrown(ExecutableType mirror) {
        ArrayList<Declaration.Thrown> thrown = new ArrayList<Declaration.Thrown>();
        for (TypeMirror typeMirror : mirror.getThrownTypes()) {
            Type.Mirror type = new Type.Mirror(typeMirror);
            int status = this.extractStatusCode(typeMirror, 500);
            Optional<Type> bodyType = this.tryExtractBodyType(typeMirror);
            thrown.add(new Declaration.Thrown(type, status, bodyType));
        }
        return List.copyOf(thrown);
    }

    private Optional<Type> tryExtractBodyType(TypeMirror exceptionType) {
        for (TypeMirror typeMirror : ((TypeElement)this.types.asElement(exceptionType)).getInterfaces()) {
            TypeElement element = (TypeElement)this.types.asElement(typeMirror);
            if (!element.getQualifiedName().contentEquals(TYPE_RETURNS)) continue;
            TypeMirror mirror = ((DeclaredType)typeMirror).getTypeArguments().get(0);
            return Optional.of(new Type.Mirror(mirror));
        }
        return Optional.empty();
    }

    private Declaration.Return extractReturn(ExecutableElement method, ExecutableType mirror) {
        TypeMirror returnType = mirror.getReturnType();
        int status = this.extractStatusCode(returnType, 200);
        return new Declaration.Return(new Type.Mirror(returnType), status);
    }

    private int extractStatusCode(TypeMirror type, int defaultStatus) {
        Element element;
        Status status = KnownAnnotations.from(type).get(Status.class);
        if (status == null && (element = this.types.asElement(type)) != null) {
            status = this.knownAnnotationsOf(element).get(Status.class);
        }
        return status != null ? status.value() : defaultStatus;
    }

    private HttpBinding extractHttpBinding(KnownAnnotations annotations, ExecutableElement method, String pathPrefix) {
        Declaration.HttpMethod httpMethod = null;
        PathTemplate template = null;
        for (Class<? extends Annotation> presentType : annotations.present()) {
            String path;
            if (!KnownAnnotations.httpMethods.contains(presentType)) continue;
            String simpleName = presentType.getSimpleName();
            if (httpMethod != null) {
                this.error("Multiple HTTP method annotations are not allowed: %s, but already was %s".formatted(simpleName, httpMethod.name()), method);
                continue;
            }
            Annotation a = annotations.get(presentType);
            if (a instanceof GET) {
                GET m = (GET)a;
                path = m.value();
            } else if (a instanceof PUT) {
                PUT m = (PUT)a;
                path = m.value();
            } else if (a instanceof POST) {
                POST m = (POST)a;
                path = m.value();
            } else if (a instanceof PATCH) {
                PATCH m = (PATCH)a;
                path = m.value();
            } else if (a instanceof DELETE) {
                DELETE m = (DELETE)a;
                path = m.value();
            } else if (a instanceof OPTIONS) {
                OPTIONS m = (OPTIONS)a;
                path = m.value();
            } else {
                path = "";
            }
            template = PathTemplate.from(pathPrefix + path);
            httpMethod = Declaration.HttpMethod.valueOf(simpleName);
        }
        if (httpMethod == null) {
            this.error("No HTTP method annotation is found on '%s'. Use one of @GET, @POST, @PUT etc.".formatted(method.getSimpleName()), method);
            httpMethod = Declaration.HttpMethod.GET;
            template = PathTemplate.from(pathPrefix);
        }
        return new HttpBinding(template, httpMethod);
    }

    private String commentOf(Element element) {
        return this.datatypes.commentOf(element);
    }

    private record HttpBinding(PathTemplate template, Declaration.HttpMethod method) {
    }
}

