/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.declaration.processor;

import io.immutables.declaration.processor.Declaration;
import io.immutables.declaration.processor.KnownAnnotations;
import io.immutables.declaration.processor.Type;
import io.immutables.meta.Inline;
import io.immutables.meta.InsertOrder;
import io.immutables.meta.Null;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

class DatatypeIntrospector {
    private final ProcessingEnvironment processing;
    private final Elements elements;
    private final Types types;
    private int variableCounter;
    final Map<String, Declaration> declarations = new HashMap<String, Declaration>();
    final Map<AnnotatedConstruct, KnownAnnotations> annotationsCache;
    private final Map<String, Type> predeclaredTypes = new HashMap<String, Type>();
    private final Map<String, Type.Container.Kind> containerTypes;
    private final List<ReferenceInContext> toValidate;

    DatatypeIntrospector(ProcessingEnvironment processing, Map<AnnotatedConstruct, KnownAnnotations> annotationsCache) {
        this.predeclaredTypes.put(String.class.getName(), Type.Primitive.String);
        this.predeclaredTypes.put(OptionalInt.class.getName(), new Type.Container(Type.Container.Kind.OptionalPrimitive, Type.Primitive.Integer));
        this.predeclaredTypes.put(OptionalLong.class.getName(), new Type.Container(Type.Container.Kind.OptionalPrimitive, Type.Primitive.Long));
        this.predeclaredTypes.put(OptionalDouble.class.getName(), new Type.Container(Type.Container.Kind.OptionalPrimitive, Type.Primitive.Float));
        this.containerTypes = new HashMap<String, Type.Container.Kind>();
        this.containerTypes.put(Optional.class.getName(), Type.Container.Kind.Optional);
        this.containerTypes.put(List.class.getName(), Type.Container.Kind.List);
        this.containerTypes.put(Set.class.getName(), Type.Container.Kind.Set);
        this.toValidate = new ArrayList<ReferenceInContext>();
        this.processing = processing;
        this.elements = processing.getElementUtils();
        this.types = processing.getTypeUtils();
        this.annotationsCache = annotationsCache;
        this.collectBoxedTypes();
    }

    private void collectBoxedTypes() {
        this.addBoxedType(TypeKind.BOOLEAN, Type.Primitive.Boolean);
        this.addBoxedType(TypeKind.INT, Type.Primitive.Integer);
        this.addBoxedType(TypeKind.LONG, Type.Primitive.Long);
        this.addBoxedType(TypeKind.DOUBLE, Type.Primitive.Float);
        this.addBoxedType(TypeKind.BOOLEAN, Type.Primitive.Boolean);
    }

    private void addBoxedType(TypeKind kind, Type.Primitive primitive) {
        assert (kind.isPrimitive());
        TypeElement boxed = this.types.boxedClass(this.types.getPrimitiveType(kind));
        String qualifiedName = boxed.getQualifiedName().toString();
        this.predeclaredTypes.put(qualifiedName, primitive);
    }

    Optional<Declaration> introspect(TypeElement element) {
        String qualifiedName = element.getQualifiedName().toString();
        return Optional.ofNullable(this.declarations.computeIfAbsent(qualifiedName, k -> this.declarationFrom(element)));
    }

    @Null
    private Declaration declarationFrom(TypeElement element) {
        return switch (element.getKind()) {
            case ElementKind.ENUM -> this.enumFrom(element);
            case ElementKind.RECORD -> this.recordFrom(element);
            case ElementKind.INTERFACE -> this.sealedFrom(element);
            default -> null;
        };
    }

    @Null
    private Declaration sealedFrom(TypeElement element) {
        if (!element.getModifiers().contains((Object)Modifier.SEALED)) {
            return null;
        }
        Map<String, Type.Variable> typeVariables = this.mapTypeVariables(element);
        Declaration.Reference reference = this.reference(element);
        List<Declaration> cases = element.getPermittedSubclasses().stream().map(t -> (TypeElement)this.types.asElement((TypeMirror)t)).map(this::introspect).mapMulti(Optional::ifPresent).toList();
        this.matchTypeVariables(element, reference, cases, typeVariables);
        return new Declaration.Sealed(Declaration.Sealed.Tag.Is, reference, List.copyOf(typeVariables.values()), cases, this.commentOf(element));
    }

    private void matchTypeVariables(TypeElement element, Declaration.Reference sealed, List<Declaration> cases, Map<String, Type.Variable> variables) {
        List<String> sealedParams = variables.values().stream().map(Type.Variable::name).toList();
        for (Declaration c : cases) {
            List<String> caseParams = ((Declaration.Parameterizable)((Object)c)).parameters().stream().map(Type.Variable::name).toList();
            if (caseParams.equals(sealedParams)) continue;
            this.error("Case type parameters of %s %s mismatch with sealed interface %s %s".formatted(DatatypeIntrospector.show(c), caseParams, DatatypeIntrospector.show(sealed), sealedParams), element);
        }
    }

    private static String show(Declaration declaration) {
        return DatatypeIntrospector.show(declaration.reference());
    }

    private static String show(Declaration.Reference r) {
        return r.module() + ":" + r.name();
    }

    private Declaration recordFrom(TypeElement element) {
        KnownAnnotations annotations = this.knownAnnotationsOf(element);
        boolean isInline = annotations.has(Inline.class);
        Declaration.Reference reference = this.reference(element);
        Map<String, Type.Variable> typeVariables = this.mapTypeVariables(element);
        List<Type.Variable> vars = List.copyOf(typeVariables.values());
        ArrayList<Declaration.Component> components = new ArrayList<Declaration.Component>();
        for (RecordComponentElement recordComponentElement : element.getRecordComponents()) {
            components.add(this.componentFrom(recordComponentElement, typeVariables));
        }
        Record declaration = isInline ? (components.size() == 1 ? new Declaration.Inline(Declaration.Inline.Tag.Is, reference, vars, (Declaration.Component)components.get(0), this.commentOf(element)) : new Declaration.Product(Declaration.Product.Tag.Is, reference, vars, List.copyOf(components), this.commentOf(element))) : new Declaration.Record(Declaration.Record.Tag.Is, reference, vars, List.copyOf(components), this.commentOf(element));
        return declaration;
    }

    private @InsertOrder Map<String, Type.Variable> mapTypeVariables(TypeElement element) {
        if (element.getTypeParameters().isEmpty()) {
            return Map.of();
        }
        LinkedHashMap<String, Type.Variable> variables = new LinkedHashMap<String, Type.Variable>();
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            String name = typeParameterElement.getSimpleName().toString();
            variables.put(name, this.allocateVariable(name));
        }
        return variables;
    }

    private Declaration enumFrom(TypeElement element) {
        List<Declaration.Enum.Constant> constants = element.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.ENUM_CONSTANT).map(e -> e.getSimpleName().toString()).map(Declaration.Enum.Constant::new).toList();
        return new Declaration.Enum(Declaration.Enum.Tag.Is, this.reference(element), constants, this.commentOf(element));
    }

    private Type.Variable allocateVariable(String name) {
        return new Type.Variable(++this.variableCounter, name);
    }

    private Declaration.Component componentFrom(RecordComponentElement component, Map<String, Type.Variable> typeVariables) {
        TypeMirror typeMirror = component.asType();
        TypeDecoder decoder = new TypeDecoder(component, typeMirror, typeVariables);
        String name = component.getSimpleName().toString();
        Type type = decoder.decode(this.knownAnnotationsOf(component));
        return new Declaration.Component(name, type, typeMirror.toString(), this.commentOf(component));
    }

    Declaration.Reference reference(TypeElement element) {
        return new Declaration.Reference(this.moduleOf(element), this.nameOf(element));
    }

    private String moduleOf(TypeElement element) {
        return this.elements.getPackageOf(element).getQualifiedName().toString();
    }

    private String nameOf(TypeElement element) {
        ArrayList<Name> nameParts = new ArrayList<Name>();
        Element e = element;
        while (e.getKind() != ElementKind.PACKAGE) {
            nameParts.add(0, e.getSimpleName());
            e = e.getEnclosingElement();
        }
        return String.join((CharSequence)".", nameParts);
    }

    private void error(String message, Element element) {
        this.processing.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private KnownAnnotations knownAnnotationsOf(AnnotatedConstruct type) {
        return this.annotationsCache.computeIfAbsent(type, KnownAnnotations::from);
    }

    String commentOf(Element element) {
        String c = this.elements.getDocComment(element);
        return c != null ? c : "";
    }

    class TypeDecoder {
        final Element element;
        final TypeMirror start;
        final Map<String, Type.Variable> variables;

        TypeDecoder(Element element, TypeMirror start, Map<String, Type.Variable> variables) {
            this.element = element;
            this.start = start;
            this.variables = variables;
        }

        Type decode(KnownAnnotations annotations) {
            return this.decode(this.start, annotations);
        }

        Type decode(TypeMirror type, KnownAnnotations elementAnnotations) {
            KnownAnnotations typeUseAnnotations = DatatypeIntrospector.this.knownAnnotationsOf(type);
            boolean nullComponent = elementAnnotations.has(Null.class);
            TypeKind kind = type.getKind();
            if (kind.isPrimitive() && nullComponent) {
                DatatypeIntrospector.this.error("Do not use @%s annotation on a primitive type '%s'".formatted(Null.class.getSimpleName(), type), this.element);
            }
            return switch (kind) {
                default -> throw new IncompatibleClassChangeError();
                case TypeKind.NULL -> Type.Primitive.Null;
                case TypeKind.VOID -> Type.Primitive.Void;
                case TypeKind.BOOLEAN -> Type.Primitive.Boolean;
                case TypeKind.DOUBLE -> Type.Primitive.Float;
                case TypeKind.INT -> Type.Primitive.Integer;
                case TypeKind.LONG -> Type.Primitive.Long;
                case TypeKind.BYTE, TypeKind.SHORT -> this.unsupported(type, this.element, "Use 'int' instead");
                case TypeKind.FLOAT -> this.unsupported(type, this.element, "Use 'double' instead");
                case TypeKind.CHAR -> this.unsupported(type, this.element, "Use 'String' instead");
                case TypeKind.DECLARED -> {
                    DeclaredType declared = (DeclaredType)type;
                    yield this.decodeDeclared(declared, (TypeElement)declared.asElement(), elementAnnotations, typeUseAnnotations);
                }
                case TypeKind.TYPEVAR -> {
                    String name = ((TypeVariable)type).asElement().getSimpleName().toString();
                    Type.Variable v = this.variables.get(name);
                    if (v != null) {
                        yield v;
                    }
                    yield this.unsupported(type, this.element, "Unmapped type variable");
                }
                case TypeKind.ARRAY -> this.unsupported(type, this.element, "Use 'List' or 'Set' instead");
                case TypeKind.WILDCARD -> this.unsupported(type, this.element, "Replace wildcard with just an element");
                case TypeKind.OTHER, TypeKind.NONE, TypeKind.ERROR, TypeKind.PACKAGE, TypeKind.EXECUTABLE, TypeKind.UNION, TypeKind.INTERSECTION, TypeKind.MODULE -> this.unsupported(type, this.element, "Unexpected here");
            };
        }

        private Type decodeDeclared(DeclaredType type, TypeElement typeElement, KnownAnnotations elementAnnotations, KnownAnnotations typeUseAnnotations) {
            String qualifiedName = typeElement.getQualifiedName().toString();
            Type predeclared = DatatypeIntrospector.this.predeclaredTypes.get(qualifiedName);
            if (predeclared != null) {
                return this.wrapByAnnotations(predeclared, elementAnnotations, typeUseAnnotations);
            }
            Type.Container.Kind containerKind = DatatypeIntrospector.this.containerTypes.get(qualifiedName);
            if (containerKind != null) {
                TypeMirror a = this.requiredTypeArgument(type, 0);
                if (a == null) {
                    return Type.Primitive.Void;
                }
                Type elementType = this.decode(a, KnownAnnotations.Empty);
                Type.Container containerType = new Type.Container(containerKind, elementType);
                return this.wrapByAnnotations(containerType, elementAnnotations, typeUseAnnotations);
            }
            if (!type.getTypeArguments().isEmpty()) {
                Declaration.Reference reference = this.reference(typeElement);
                ArrayList<Type> arguments = new ArrayList<Type>();
                for (TypeMirror typeMirror : type.getTypeArguments()) {
                    arguments.add(this.decode(typeMirror, KnownAnnotations.Empty));
                }
                Type.Applied appliedType = new Type.Applied(reference, List.copyOf(arguments));
                return this.wrapByAnnotations(appliedType, elementAnnotations, typeUseAnnotations);
            }
            Type.Terminal terminalType = new Type.Terminal(this.reference(typeElement));
            return this.wrapByAnnotations(terminalType, elementAnnotations, typeUseAnnotations);
        }

        private Declaration.Reference reference(TypeElement typeElement) {
            String module = DatatypeIntrospector.this.moduleOf(typeElement);
            String name = DatatypeIntrospector.this.nameOf(typeElement);
            Declaration.Reference reference = new Declaration.Reference(module, name);
            this.enque(reference);
            return reference;
        }

        private void enque(Declaration.Reference reference) {
            DatatypeIntrospector.this.toValidate.add(new ReferenceInContext(reference, this.element));
        }

        private Type wrapByAnnotations(Type argument, KnownAnnotations elementAnnotations, KnownAnnotations typeUseAnnotations) {
            if (elementAnnotations.has(Null.class)) {
                return new Type.Container(Type.Container.Kind.Nullable, argument);
            }
            return argument;
        }

        @Null
        private TypeMirror requiredTypeArgument(DeclaredType type, int index) {
            List<? extends TypeMirror> arguments = type.getTypeArguments();
            assert (index >= 0);
            if (index < arguments.size()) {
                return arguments.get(index);
            }
            DatatypeIntrospector.this.error("Missing required type argument in %s [%d]".formatted(type, index), this.element);
            return null;
        }

        private Type unsupported(TypeMirror type, Element element, String explain) {
            DatatypeIntrospector.this.error("Unsupported type %s (%s). %s".formatted(new Object[]{type, type.getKind(), explain}), element);
            return Type.Primitive.Void;
        }
    }

    record ReferenceInContext(Declaration.Reference reference, Element inContext) {
    }
}

