/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.declaration.processor;

import io.immutables.declaration.processor.Documented;
import io.immutables.declaration.processor.PathTemplate;
import io.immutables.declaration.processor.Type;
import io.immutables.meta.Null;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Declaration
extends Documented {
    public Reference reference();

    default public String name() {
        return this.reference().name();
    }

    default public String module() {
        return this.reference().module();
    }

    public record Reference(String module, String name) {
    }

    public static enum HttpMethod {
        GET,
        PUT,
        POST,
        DELETE,
        PATCH,
        OPTIONS;

    }

    public record Parameter(String name, String httpName, int index, Type type, Mapping mapping, String comment) implements Documented
    {

        public static enum Mapping {
            Path,
            Query,
            Body,
            Unmapped;

        }
    }

    public record Thrown(Type type, int status, Optional<Type> bodyType) {
    }

    public record Return(Type type, int status) {
    }

    public record FixedQuery(String name, @Null String value) {
    }

    public record Operation(String name, PathTemplate path, HttpMethod method, Return returns, List<Thrown> thrown, List<Parameter> parameters, List<FixedQuery> fixedQuery, String comment) implements Documented
    {
    }

    public record Contract(Tag contract, Reference reference, String pathPrefix, Map<String, Operation> operations, String comment) implements Declaration
    {

        public static enum Tag {
            Is;

        }
    }

    public record Component(String name, Type type, String javaType, String comment) implements Documented
    {
    }

    public record Sealed(Tag sealed, Reference reference, List<Type.Variable> parameters, List<Declaration> cases, String comment) implements Declaration,
    Parameterizable
    {

        public static enum Tag {
            Is;

        }
    }

    public record Record(Tag product, Reference reference, List<Type.Variable> parameters, List<Component> components, String comment) implements Declaration,
    Parameterizable
    {

        public static enum Tag {
            Is;

        }
    }

    public record Enum(Tag enums, Reference reference, List<Constant> constants, String comment) implements Declaration
    {

        public static enum Tag {
            Is;

        }

        record Constant(String name) {
        }
    }

    public record Product(Tag product, Reference reference, List<Type.Variable> parameters, List<Component> components, String comment) implements Declaration,
    Parameterizable
    {
        public Product {
            assert (components.size() >= 2);
        }

        public static enum Tag {
            Is;

        }
    }

    public record Inline(Tag inline, Reference reference, List<Type.Variable> parameters, Component component, String comment) implements Declaration,
    Parameterizable
    {

        public static enum Tag {
            Is;

        }
    }

    public static interface Parameterizable {
        public List<Type.Variable> parameters();
    }
}

