/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.declaration.processor;

import io.immutables.declaration.ServiceInventory;
import io.immutables.declaration.processor.Declaration;
import io.immutables.declaration.processor.InventoryDiscoverer;
import io.immutables.meta.Late;
import io.immutables.stencil.template.ProcessingCurrent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public abstract class DeclarationsProcessor
extends AbstractProcessor {
    private final Map<String, List<Declaration>> declarationsByPackage = new HashMap<String, List<Declaration>>();
    @Late
    private InventoryDiscoverer discoverer;
    @Late
    private ProcessingCurrent current;

    @Override
    public synchronized void init(ProcessingEnvironment processing) {
        super.init(processing);
        this.discoverer = new InventoryDiscoverer(processing);
        this.current = new ProcessingCurrent(processing);
    }

    protected final ProcessingCurrent current() {
        return this.current;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_17;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(ServiceInventory.class.getName());
    }

    protected abstract void process(String var1, Collection<Declaration> var2);

    protected void over(Map<String, List<Declaration>> declarations) {
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment round) {
        if (round.processingOver()) {
            this.over(this.declarationsByPackage);
            return true;
        }
        try {
            Set<? extends Element> inventoryPackages = round.getElementsAnnotatedWith(ServiceInventory.class);
            for (Element element : inventoryPackages) {
                String packageName = ((PackageElement)element).getQualifiedName().toString();
                List<Declaration> declarations = this.discoverer.discover(element);
                this.declarationsByPackage.put(packageName, declarations);
                this.process(packageName, declarations);
            }
        }
        catch (Throwable e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e + "\n" + this.toStackTraceString(e));
        }
        return true;
    }

    private CharSequence toStackTraceString(Throwable e) {
        StringWriter w = new StringWriter();
        try (PrintWriter pw = new PrintWriter(w);){
            e.printStackTrace(pw);
        }
        return w.toString();
    }
}

