/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.declaration.processor;

import io.immutables.declaration.Exclude;
import io.immutables.declaration.http.Path;
import io.immutables.declaration.processor.ContractIntrospector;
import io.immutables.declaration.processor.DatatypeIntrospector;
import io.immutables.declaration.processor.Declaration;
import io.immutables.declaration.processor.KnownAnnotations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

class InventoryDiscoverer {
    private final ProcessingEnvironment processing;
    private final ContractIntrospector contracts;
    private final DatatypeIntrospector datatypes;
    private final Map<AnnotatedConstruct, KnownAnnotations> annotationsCache = new HashMap<AnnotatedConstruct, KnownAnnotations>();

    InventoryDiscoverer(ProcessingEnvironment processing) {
        this.processing = processing;
        this.datatypes = new DatatypeIntrospector(processing, this.annotationsCache);
        this.contracts = new ContractIntrospector(processing, this.datatypes, this.annotationsCache);
    }

    List<Declaration> discover(Element inventoryPackage) {
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        block4: for (Element element : inventoryPackage.getEnclosedElements()) {
            KnownAnnotations annotations = this.annotationsCache.computeIfAbsent(element, KnownAnnotations::from);
            if (annotations.has(Exclude.class)) continue;
            switch (element.getKind()) {
                case ENUM: 
                case RECORD: {
                    TypeElement type = (TypeElement)element;
                    this.datatypes.introspect(type).ifPresent(declarations::add);
                    break;
                }
                case INTERFACE: {
                    TypeElement type = (TypeElement)element;
                    if (annotations.has(Path.class)) {
                        this.contracts.introspect(type).ifPresent(declarations::add);
                        break;
                    }
                    if (!type.getModifiers().contains((Object)Modifier.SEALED)) continue block4;
                    this.datatypes.introspect(type).ifPresent(declarations::add);
                    break;
                }
                default: {
                    this.processing.getMessager().printMessage(Diagnostic.Kind.ERROR, "Not supported element of container: " + element.getKind(), element);
                }
            }
        }
        return declarations;
    }
}

