/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.declaration.processor;

import io.immutables.declaration.Exclude;
import io.immutables.declaration.http.DELETE;
import io.immutables.declaration.http.GET;
import io.immutables.declaration.http.OPTIONS;
import io.immutables.declaration.http.PATCH;
import io.immutables.declaration.http.POST;
import io.immutables.declaration.http.PUT;
import io.immutables.declaration.http.Path;
import io.immutables.declaration.http.Status;
import io.immutables.meta.Inline;
import io.immutables.meta.Null;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;

class KnownAnnotations {
    private final Map<Class<? extends Annotation>, Object> annotations;
    static final Set<Class<? extends Annotation>> httpMethods = Set.of(GET.class, PUT.class, POST.class, PATCH.class, DELETE.class, OPTIONS.class);
    private static final Set<Class<? extends Annotation>> other = Set.of(Path.class, Status.class, Exclude.class, Null.class, Inline.class);
    private static final Map<String, Class<? extends Annotation>> knownByName;
    static final KnownAnnotations Empty;

    KnownAnnotations(Map<Class<? extends Annotation>, Object> annotations) {
        this.annotations = annotations;
    }

    boolean has(Class<? extends Annotation> type) {
        return this.annotations.containsKey(type);
    }

    Set<Class<? extends Annotation>> present() {
        return this.annotations.keySet();
    }

    @Null
    <A extends Annotation> A get(Class<? extends A> type) {
        return (A)((Annotation)type.cast(this.annotations.get(type)));
    }

    static KnownAnnotations from(AnnotatedConstruct annotated) {
        HashMap<Class<? extends Annotation>, Object> found = new HashMap<Class<? extends Annotation>, Object>();
        for (AnnotationMirror annotationMirror : annotated.getAnnotationMirrors()) {
            TypeElement typeElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Class<? extends Annotation> type = knownByName.get(typeElement.getQualifiedName().toString());
            if (type == null) continue;
            Annotation synthesized = annotated.getAnnotation(type);
            assert (synthesized != null);
            found.put(type, synthesized);
        }
        return new KnownAnnotations(found);
    }

    static {
        HashMap<String, Class<? extends Annotation>> byName = new HashMap<String, Class<? extends Annotation>>();
        for (Class<? extends Annotation> c : httpMethods) {
            byName.put(c.getCanonicalName(), c);
        }
        for (Class<? extends Annotation> c : other) {
            byName.put(c.getCanonicalName(), c);
        }
        knownByName = Map.copyOf(byName);
        Empty = new KnownAnnotations(Map.of());
    }
}

