/*
 * Decompiled with CFR 0.152.
 */
package io.immutables.declaration.processor;

import io.immutables.declaration.processor.Declaration;
import io.immutables.meta.Null;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PathTemplate {
    public final String uri;
    public final String path;
    public final Map<String, Parameter> parameters;
    private static final Pattern parameterPattern = Pattern.compile("\\{\\s*([a-zA-Z][0-9a-zA-Z]*)\\s*}");

    private PathTemplate(String uri, String path, Map<String, Parameter> parameters) {
        this.uri = uri;
        this.path = path;
        this.parameters = Map.copyOf(parameters);
    }

    public String toString() {
        return this.uri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PathTemplate)) return false;
        PathTemplate p = (PathTemplate)obj;
        if (!this.uri.equals(p.uri)) return false;
        return true;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public static PathTemplate from(String uri) {
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        String path = PathTemplate.collectFromPath(uri, parameters);
        PathTemplate.collectFromQuery(uri, parameters);
        return new PathTemplate(uri, path, parameters);
    }

    private static String collectFromPath(String uri, Map<String, Parameter> parameters) {
        int queryAt = uri.indexOf(63);
        if (queryAt >= 0) {
            uri = uri.substring(0, queryAt);
        }
        Matcher matcher = parameterPattern.matcher(uri);
        while (matcher.find()) {
            String name = matcher.group(1);
            parameters.put(name, new Parameter(name, name, Parameter.Kind.Path, null));
        }
        return uri;
    }

    private static void collectFromQuery(String uri, Map<String, Parameter> parameters) {
        int queryAt = uri.indexOf(63);
        if (queryAt >= 0 && queryAt + 1 < uri.length()) {
            String queryPart = uri.substring(queryAt + 1);
            for (String q : queryPart.split("&")) {
                int indexOfEquals = q.indexOf(61);
                if (indexOfEquals >= 0) {
                    String value;
                    String httpName;
                    String name;
                    String k = q.substring(0, indexOfEquals);
                    String v = q.substring(indexOfEquals + 1);
                    Matcher matcher = parameterPattern.matcher(v);
                    if (matcher.matches()) {
                        name = matcher.group(1);
                        httpName = k;
                        value = null;
                    } else {
                        name = k;
                        httpName = k;
                        value = v;
                    }
                    parameters.put(name, new Parameter(name, httpName, Parameter.Kind.Query, value));
                    continue;
                }
                parameters.put(q, new Parameter(q, q, Parameter.Kind.Query, null));
            }
        }
    }

    public String with(List<Declaration.FixedQuery> queries) {
        if (queries.isEmpty()) {
            return this.path;
        }
        StringBuilder b = new StringBuilder(this.path).append('?');
        for (Declaration.FixedQuery q : queries) {
            b.append(q.name());
            if (q.value() == null) continue;
            b.append('=').append(q.value());
        }
        return b.toString();
    }

    record Parameter(String name, String httpName, Kind kind, @Null String value) {

        static enum Kind {
            Path,
            Query;

        }
    }
}

