/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.calls.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ShowCallRequest.Builder.class)
public final class ShowCallRequest {
    private final String callId;

    private final Map<String, Object> additionalProperties;

    private ShowCallRequest(String callId, Map<String, Object> additionalProperties) {
        this.callId = callId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The id of the call to retrieve
     */
    @JsonProperty("call_id")
    public String getCallId() {
        return callId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ShowCallRequest && equalTo((ShowCallRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ShowCallRequest other) {
        return callId.equals(other.callId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.callId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CallIdStage builder() {
        return new Builder();
    }

    public interface CallIdStage {
        /**
         * <p>The id of the call to retrieve</p>
         */
        _FinalStage callId(@NotNull String callId);

        Builder from(ShowCallRequest other);
    }

    public interface _FinalStage {
        ShowCallRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CallIdStage, _FinalStage {
        private String callId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ShowCallRequest other) {
            callId(other.getCallId());
            return this;
        }

        /**
         * <p>The id of the call to retrieve</p>
         * <p>The id of the call to retrieve</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("call_id")
        public _FinalStage callId(@NotNull String callId) {
            this.callId = Objects.requireNonNull(callId, "callId must not be null");
            return this;
        }

        @java.lang.Override
        public ShowCallRequest build() {
            return new ShowCallRequest(callId, additionalProperties);
        }
    }
}
