/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.internalarticles;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.internalarticles.requests.DeleteInternalArticleRequest;
import com.intercom.api.resources.internalarticles.requests.RetrieveInternalArticleRequest;
import com.intercom.api.resources.internalarticles.requests.SearchInternalArticlesRequest;
import com.intercom.api.resources.internalarticles.requests.UpdateInternalArticleRequestBody;
import com.intercom.api.resources.internalarticles.types.InternalArticleListItem;
import com.intercom.api.resources.internalarticles.types.InternalArticleSearchResponse;
import com.intercom.api.types.CreateInternalArticleRequest;
import com.intercom.api.types.DeletedInternalArticleObject;
import com.intercom.api.types.InternalArticleList;
import java.util.Optional;

public class InternalArticlesClient {
    protected final ClientOptions clientOptions;

    private final RawInternalArticlesClient rawClient;

    public InternalArticlesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawInternalArticlesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawInternalArticlesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all internal articles by making a GET request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public InternalArticleList listInternalArticles() {
        return this.rawClient.listInternalArticles().body();
    }

    /**
     * You can fetch a list of all internal articles by making a GET request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public InternalArticleList listInternalArticles(RequestOptions requestOptions) {
        return this.rawClient.listInternalArticles(requestOptions).body();
    }

    /**
     * You can create a new internal article by making a POST request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public InternalArticleListItem createInternalArticle() {
        return this.rawClient.createInternalArticle().body();
    }

    /**
     * You can create a new internal article by making a POST request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public InternalArticleListItem createInternalArticle(Optional<CreateInternalArticleRequest> request) {
        return this.rawClient.createInternalArticle(request).body();
    }

    /**
     * You can create a new internal article by making a POST request to <code>https://api.intercom.io/internal_articles</code>.
     */
    public InternalArticleListItem createInternalArticle(
            Optional<CreateInternalArticleRequest> request, RequestOptions requestOptions) {
        return this.rawClient.createInternalArticle(request, requestOptions).body();
    }

    /**
     * You can fetch the details of a single internal article by making a GET request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public InternalArticleListItem retrieveInternalArticle(RetrieveInternalArticleRequest request) {
        return this.rawClient.retrieveInternalArticle(request).body();
    }

    /**
     * You can fetch the details of a single internal article by making a GET request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public InternalArticleListItem retrieveInternalArticle(
            RetrieveInternalArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveInternalArticle(request, requestOptions).body();
    }

    /**
     * You can update the details of a single internal article by making a PUT request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public InternalArticleListItem updateInternalArticle(UpdateInternalArticleRequestBody request) {
        return this.rawClient.updateInternalArticle(request).body();
    }

    /**
     * You can update the details of a single internal article by making a PUT request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public InternalArticleListItem updateInternalArticle(
            UpdateInternalArticleRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateInternalArticle(request, requestOptions).body();
    }

    /**
     * You can delete a single internal article by making a DELETE request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public DeletedInternalArticleObject deleteInternalArticle(DeleteInternalArticleRequest request) {
        return this.rawClient.deleteInternalArticle(request).body();
    }

    /**
     * You can delete a single internal article by making a DELETE request to <code>https://api.intercom.io/internal_articles/&lt;id&gt;</code>.
     */
    public DeletedInternalArticleObject deleteInternalArticle(
            DeleteInternalArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteInternalArticle(request, requestOptions).body();
    }

    /**
     * You can search for internal articles by making a GET request to <code>https://api.intercom.io/internal_articles/search</code>.
     */
    public InternalArticleSearchResponse searchInternalArticles() {
        return this.rawClient.searchInternalArticles().body();
    }

    /**
     * You can search for internal articles by making a GET request to <code>https://api.intercom.io/internal_articles/search</code>.
     */
    public InternalArticleSearchResponse searchInternalArticles(SearchInternalArticlesRequest request) {
        return this.rawClient.searchInternalArticles(request).body();
    }

    /**
     * You can search for internal articles by making a GET request to <code>https://api.intercom.io/internal_articles/search</code>.
     */
    public InternalArticleSearchResponse searchInternalArticles(
            SearchInternalArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchInternalArticles(request, requestOptions).body();
    }
}
