/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickets.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.tickets.types.TicketsReplyRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ReplyToTicketRequest.Builder.class)
public final class ReplyToTicketRequest {
    private final String ticketId;

    private final TicketsReplyRequestBody body;

    private final Map<String, Object> additionalProperties;

    private ReplyToTicketRequest(
            String ticketId, TicketsReplyRequestBody body, Map<String, Object> additionalProperties) {
        this.ticketId = ticketId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("ticket_id")
    public String getTicketId() {
        return ticketId;
    }

    @JsonProperty("body")
    public TicketsReplyRequestBody getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ReplyToTicketRequest && equalTo((ReplyToTicketRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ReplyToTicketRequest other) {
        return ticketId.equals(other.ticketId) && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.ticketId, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketIdStage builder() {
        return new Builder();
    }

    public interface TicketIdStage {
        BodyStage ticketId(@NotNull String ticketId);

        Builder from(ReplyToTicketRequest other);
    }

    public interface BodyStage {
        _FinalStage body(@NotNull TicketsReplyRequestBody body);
    }

    public interface _FinalStage {
        ReplyToTicketRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TicketIdStage, BodyStage, _FinalStage {
        private String ticketId;

        private TicketsReplyRequestBody body;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ReplyToTicketRequest other) {
            ticketId(other.getTicketId());
            body(other.getBody());
            return this;
        }

        @java.lang.Override
        @JsonSetter("ticket_id")
        public BodyStage ticketId(@NotNull String ticketId) {
            this.ticketId = Objects.requireNonNull(ticketId, "ticketId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull TicketsReplyRequestBody body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public ReplyToTicketRequest build() {
            return new ReplyToTicketRequest(ticketId, body, additionalProperties);
        }
    }
}
