/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.admins.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.TeamPriorityLevel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Admin.Builder.class)
public final class Admin {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> name;

    private final Optional<String> email;

    private final Optional<String> jobTitle;

    private final Optional<Boolean> awayModeEnabled;

    private final Optional<Boolean> awayModeReassign;

    private final Optional<Integer> awayStatusReasonId;

    private final Optional<Boolean> hasInboxSeat;

    private final Optional<List<Integer>> teamIds;

    private final Optional<String> avatar;

    private final Optional<TeamPriorityLevel> teamPriorityLevel;

    private final Map<String, Object> additionalProperties;

    private Admin(
            Optional<String> type,
            Optional<String> id,
            Optional<String> name,
            Optional<String> email,
            Optional<String> jobTitle,
            Optional<Boolean> awayModeEnabled,
            Optional<Boolean> awayModeReassign,
            Optional<Integer> awayStatusReasonId,
            Optional<Boolean> hasInboxSeat,
            Optional<List<Integer>> teamIds,
            Optional<String> avatar,
            Optional<TeamPriorityLevel> teamPriorityLevel,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.jobTitle = jobTitle;
        this.awayModeEnabled = awayModeEnabled;
        this.awayModeReassign = awayModeReassign;
        this.awayStatusReasonId = awayStatusReasonId;
        this.hasInboxSeat = hasInboxSeat;
        this.teamIds = teamIds;
        this.avatar = avatar;
        this.teamPriorityLevel = teamPriorityLevel;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>admin</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id representing the admin.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The name of the admin.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The email of the admin.
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return The job title of the admin.
     */
    @JsonProperty("job_title")
    public Optional<String> getJobTitle() {
        return jobTitle;
    }

    /**
     * @return Identifies if this admin is currently set in away mode.
     */
    @JsonProperty("away_mode_enabled")
    public Optional<Boolean> getAwayModeEnabled() {
        return awayModeEnabled;
    }

    /**
     * @return Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.
     */
    @JsonProperty("away_mode_reassign")
    public Optional<Boolean> getAwayModeReassign() {
        return awayModeReassign;
    }

    /**
     * @return The unique identifier of the away status reason
     */
    @JsonProperty("away_status_reason_id")
    public Optional<Integer> getAwayStatusReasonId() {
        return awayStatusReasonId;
    }

    /**
     * @return Identifies if this admin has a paid inbox seat to restrict/allow features that require them.
     */
    @JsonProperty("has_inbox_seat")
    public Optional<Boolean> getHasInboxSeat() {
        return hasInboxSeat;
    }

    /**
     * @return This object represents the avatar associated with the admin.
     */
    @JsonProperty("team_ids")
    public Optional<List<Integer>> getTeamIds() {
        return teamIds;
    }

    /**
     * @return Image for the associated team or teammate
     */
    @JsonProperty("avatar")
    public Optional<String> getAvatar() {
        return avatar;
    }

    @JsonProperty("team_priority_level")
    public Optional<TeamPriorityLevel> getTeamPriorityLevel() {
        return teamPriorityLevel;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Admin && equalTo((Admin) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Admin other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && name.equals(other.name)
                && email.equals(other.email)
                && jobTitle.equals(other.jobTitle)
                && awayModeEnabled.equals(other.awayModeEnabled)
                && awayModeReassign.equals(other.awayModeReassign)
                && awayStatusReasonId.equals(other.awayStatusReasonId)
                && hasInboxSeat.equals(other.hasInboxSeat)
                && teamIds.equals(other.teamIds)
                && avatar.equals(other.avatar)
                && teamPriorityLevel.equals(other.teamPriorityLevel);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.name,
                this.email,
                this.jobTitle,
                this.awayModeEnabled,
                this.awayModeReassign,
                this.awayStatusReasonId,
                this.hasInboxSeat,
                this.teamIds,
                this.avatar,
                this.teamPriorityLevel);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<String> jobTitle = Optional.empty();

        private Optional<Boolean> awayModeEnabled = Optional.empty();

        private Optional<Boolean> awayModeReassign = Optional.empty();

        private Optional<Integer> awayStatusReasonId = Optional.empty();

        private Optional<Boolean> hasInboxSeat = Optional.empty();

        private Optional<List<Integer>> teamIds = Optional.empty();

        private Optional<String> avatar = Optional.empty();

        private Optional<TeamPriorityLevel> teamPriorityLevel = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Admin other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            email(other.getEmail());
            jobTitle(other.getJobTitle());
            awayModeEnabled(other.getAwayModeEnabled());
            awayModeReassign(other.getAwayModeReassign());
            awayStatusReasonId(other.getAwayStatusReasonId());
            hasInboxSeat(other.getHasInboxSeat());
            teamIds(other.getTeamIds());
            avatar(other.getAvatar());
            teamPriorityLevel(other.getTeamPriorityLevel());
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>admin</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The id representing the admin.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The name of the admin.</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The email of the admin.</p>
         */
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>The job title of the admin.</p>
         */
        @JsonSetter(value = "job_title", nulls = Nulls.SKIP)
        public Builder jobTitle(Optional<String> jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = Optional.ofNullable(jobTitle);
            return this;
        }

        /**
         * <p>Identifies if this admin is currently set in away mode.</p>
         */
        @JsonSetter(value = "away_mode_enabled", nulls = Nulls.SKIP)
        public Builder awayModeEnabled(Optional<Boolean> awayModeEnabled) {
            this.awayModeEnabled = awayModeEnabled;
            return this;
        }

        public Builder awayModeEnabled(Boolean awayModeEnabled) {
            this.awayModeEnabled = Optional.ofNullable(awayModeEnabled);
            return this;
        }

        /**
         * <p>Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.</p>
         */
        @JsonSetter(value = "away_mode_reassign", nulls = Nulls.SKIP)
        public Builder awayModeReassign(Optional<Boolean> awayModeReassign) {
            this.awayModeReassign = awayModeReassign;
            return this;
        }

        public Builder awayModeReassign(Boolean awayModeReassign) {
            this.awayModeReassign = Optional.ofNullable(awayModeReassign);
            return this;
        }

        /**
         * <p>The unique identifier of the away status reason</p>
         */
        @JsonSetter(value = "away_status_reason_id", nulls = Nulls.SKIP)
        public Builder awayStatusReasonId(Optional<Integer> awayStatusReasonId) {
            this.awayStatusReasonId = awayStatusReasonId;
            return this;
        }

        public Builder awayStatusReasonId(Integer awayStatusReasonId) {
            this.awayStatusReasonId = Optional.ofNullable(awayStatusReasonId);
            return this;
        }

        /**
         * <p>Identifies if this admin has a paid inbox seat to restrict/allow features that require them.</p>
         */
        @JsonSetter(value = "has_inbox_seat", nulls = Nulls.SKIP)
        public Builder hasInboxSeat(Optional<Boolean> hasInboxSeat) {
            this.hasInboxSeat = hasInboxSeat;
            return this;
        }

        public Builder hasInboxSeat(Boolean hasInboxSeat) {
            this.hasInboxSeat = Optional.ofNullable(hasInboxSeat);
            return this;
        }

        /**
         * <p>This object represents the avatar associated with the admin.</p>
         */
        @JsonSetter(value = "team_ids", nulls = Nulls.SKIP)
        public Builder teamIds(Optional<List<Integer>> teamIds) {
            this.teamIds = teamIds;
            return this;
        }

        public Builder teamIds(List<Integer> teamIds) {
            this.teamIds = Optional.ofNullable(teamIds);
            return this;
        }

        /**
         * <p>Image for the associated team or teammate</p>
         */
        @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
        public Builder avatar(Optional<String> avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder avatar(String avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        @JsonSetter(value = "team_priority_level", nulls = Nulls.SKIP)
        public Builder teamPriorityLevel(Optional<TeamPriorityLevel> teamPriorityLevel) {
            this.teamPriorityLevel = teamPriorityLevel;
            return this;
        }

        public Builder teamPriorityLevel(TeamPriorityLevel teamPriorityLevel) {
            this.teamPriorityLevel = Optional.ofNullable(teamPriorityLevel);
            return this;
        }

        public Admin build() {
            return new Admin(
                    type,
                    id,
                    name,
                    email,
                    jobTitle,
                    awayModeEnabled,
                    awayModeReassign,
                    awayStatusReasonId,
                    hasInboxSeat,
                    teamIds,
                    avatar,
                    teamPriorityLevel,
                    additionalProperties);
        }
    }
}
