/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.news.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.NewsItemRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateNewsItemRequest.Builder.class)
public final class UpdateNewsItemRequest {
    private final int id;

    private final NewsItemRequest body;

    private final Map<String, Object> additionalProperties;

    private UpdateNewsItemRequest(int id, NewsItemRequest body, Map<String, Object> additionalProperties) {
        this.id = id;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the news item which is given by Intercom.
     */
    @JsonProperty("id")
    public int getId() {
        return id;
    }

    @JsonProperty("body")
    public NewsItemRequest getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateNewsItemRequest && equalTo((UpdateNewsItemRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateNewsItemRequest other) {
        return id == other.id && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * <p>The unique identifier for the news item which is given by Intercom.</p>
         */
        BodyStage id(int id);

        Builder from(UpdateNewsItemRequest other);
    }

    public interface BodyStage {
        _FinalStage body(@NotNull NewsItemRequest body);
    }

    public interface _FinalStage {
        UpdateNewsItemRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, BodyStage, _FinalStage {
        private int id;

        private NewsItemRequest body;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateNewsItemRequest other) {
            id(other.getId());
            body(other.getBody());
            return this;
        }

        /**
         * <p>The unique identifier for the news item which is given by Intercom.</p>
         * <p>The unique identifier for the news item which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public BodyStage id(int id) {
            this.id = id;
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull NewsItemRequest body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public UpdateNewsItemRequest build() {
            return new UpdateNewsItemRequest(id, body, additionalProperties);
        }
    }
}
