/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.customobjectinstances;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.customobjectinstances.AsyncRawCustomObjectInstancesClient;
import com.intercom.api.resources.customobjectinstances.requests.CreateOrUpdateCustomObjectInstanceRequest;
import com.intercom.api.resources.customobjectinstances.requests.DeleteCustomObjectInstancesByExternalIdRequest;
import com.intercom.api.resources.customobjectinstances.requests.DeleteCustomObjectInstancesByIdRequest;
import com.intercom.api.resources.customobjectinstances.requests.GetCustomObjectInstancesByExternalIdRequest;
import com.intercom.api.resources.customobjectinstances.requests.GetCustomObjectInstancesByIdRequest;
import com.intercom.api.resources.customobjectinstances.types.CustomObjectInstance;
import com.intercom.api.types.CustomObjectInstanceDeleted;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomObjectInstancesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomObjectInstancesClient rawClient;

    public AsyncCustomObjectInstancesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomObjectInstancesClient(clientOptions);
    }

    public AsyncRawCustomObjectInstancesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<Optional<CustomObjectInstance>> getCustomObjectInstancesByExternalId(GetCustomObjectInstancesByExternalIdRequest request) {
        return this.rawClient.getCustomObjectInstancesByExternalId(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<CustomObjectInstance>> getCustomObjectInstancesByExternalId(GetCustomObjectInstancesByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.getCustomObjectInstancesByExternalId(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<CustomObjectInstance>> createCustomObjectInstances(CreateOrUpdateCustomObjectInstanceRequest request) {
        return this.rawClient.createCustomObjectInstances(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<CustomObjectInstance>> createCustomObjectInstances(CreateOrUpdateCustomObjectInstanceRequest request, RequestOptions requestOptions) {
        return this.rawClient.createCustomObjectInstances(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<CustomObjectInstanceDeleted> deleteCustomObjectInstancesById(DeleteCustomObjectInstancesByIdRequest request) {
        return this.rawClient.deleteCustomObjectInstancesById(request).thenApply(response -> (CustomObjectInstanceDeleted)response.body());
    }

    public CompletableFuture<CustomObjectInstanceDeleted> deleteCustomObjectInstancesById(DeleteCustomObjectInstancesByIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteCustomObjectInstancesById(request, requestOptions).thenApply(response -> (CustomObjectInstanceDeleted)response.body());
    }

    public CompletableFuture<Optional<CustomObjectInstance>> getCustomObjectInstancesById(GetCustomObjectInstancesByIdRequest request) {
        return this.rawClient.getCustomObjectInstancesById(request).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<Optional<CustomObjectInstance>> getCustomObjectInstancesById(GetCustomObjectInstancesByIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.getCustomObjectInstancesById(request, requestOptions).thenApply(response -> (Optional)response.body());
    }

    public CompletableFuture<CustomObjectInstanceDeleted> deleteCustomObjectInstancesByExternalId(DeleteCustomObjectInstancesByExternalIdRequest request) {
        return this.rawClient.deleteCustomObjectInstancesByExternalId(request).thenApply(response -> (CustomObjectInstanceDeleted)response.body());
    }

    public CompletableFuture<CustomObjectInstanceDeleted> deleteCustomObjectInstancesByExternalId(DeleteCustomObjectInstancesByExternalIdRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteCustomObjectInstancesByExternalId(request, requestOptions).thenApply(response -> (CustomObjectInstanceDeleted)response.body());
    }
}

