/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataattributes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.QueryStringMapper;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.errors.BadRequestError;
import com.intercom.api.errors.NotFoundError;
import com.intercom.api.errors.UnauthorizedError;
import com.intercom.api.errors.UnprocessableEntityError;
import com.intercom.api.resources.dataattributes.requests.ListDataAttributesRequest;
import com.intercom.api.resources.dataattributes.requests.UpdateDataAttributeRequest;
import com.intercom.api.resources.dataattributes.types.DataAttribute;
import com.intercom.api.types.CreateDataAttributeRequest;
import com.intercom.api.types.DataAttributeList;
import com.intercom.api.types.Error;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawDataAttributesClient {
    protected final ClientOptions clientOptions;

    public RawDataAttributesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public IntercomHttpResponse<DataAttributeList> list() {
        return this.list(ListDataAttributesRequest.builder().build());
    }

    public IntercomHttpResponse<DataAttributeList> list(ListDataAttributesRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<DataAttributeList> list(ListDataAttributesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("data_attributes");
        if (request.getModel().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "model", request.getModel().get(), false);
        }
        if (request.getIncludeArchived().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "include_archived", request.getIncludeArchived().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                IntercomHttpResponse<DataAttributeList> intercomHttpResponse = new IntercomHttpResponse<DataAttributeList>((DataAttributeList)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DataAttributeList.class), response);
                return intercomHttpResponse;
            }
            try {
                if (response.code() == 401) {
                    throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<DataAttribute> create(CreateDataAttributeRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<DataAttribute> create(CreateDataAttributeRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("data_attributes").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                IntercomHttpResponse<DataAttribute> intercomHttpResponse = new IntercomHttpResponse<DataAttribute>((DataAttribute)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DataAttribute.class), response);
                return intercomHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    public IntercomHttpResponse<DataAttribute> update(UpdateDataAttributeRequest request) {
        return this.update(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IntercomHttpResponse<DataAttribute> update(UpdateDataAttributeRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("data_attributes").addPathSegment(Integer.toString(request.getDataAttributeId())).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request.getBody()), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            String responseBodyString;
            ResponseBody responseBody = response.body();
            String string = responseBodyString = responseBody != null ? responseBody.string() : "{}";
            if (response.isSuccessful()) {
                IntercomHttpResponse<DataAttribute> intercomHttpResponse = new IntercomHttpResponse<DataAttribute>((DataAttribute)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, DataAttribute.class), response);
                return intercomHttpResponse;
            }
            try {
                switch (response.code()) {
                    case 400: {
                        throw new BadRequestError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 401: {
                        throw new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    }
                    case 404: {
                        throw new NotFoundError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                    case 422: {
                        throw new UnprocessableEntityError(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
            Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
            throw new IntercomApiException("Error with status code " + response.code(), response.code(), errorBody, response);
        }
        catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}

