/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.aicontent.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContentImportSource {
    private final int id;
    private final int lastSyncedAt;
    private final SyncBehavior syncBehavior;
    private final Status status;
    private final String url;
    private final int createdAt;
    private final int updatedAt;
    private final Map<String, Object> additionalProperties;

    private ContentImportSource(int id, int lastSyncedAt, SyncBehavior syncBehavior, Status status, String url, int createdAt, int updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.lastSyncedAt = lastSyncedAt;
        this.syncBehavior = syncBehavior;
        this.status = status;
        this.url = url;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "content_import_source";
    }

    @JsonProperty(value="id")
    public int getId() {
        return this.id;
    }

    @JsonProperty(value="last_synced_at")
    public int getLastSyncedAt() {
        return this.lastSyncedAt;
    }

    @JsonProperty(value="sync_behavior")
    public SyncBehavior getSyncBehavior() {
        return this.syncBehavior;
    }

    @JsonProperty(value="status")
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public int getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentImportSource && this.equalTo((ContentImportSource)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentImportSource other) {
        return this.id == other.id && this.lastSyncedAt == other.lastSyncedAt && this.syncBehavior.equals(other.syncBehavior) && this.status.equals(other.status) && this.url.equals(other.url) && this.createdAt == other.createdAt && this.updatedAt == other.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.lastSyncedAt, this.syncBehavior, this.status, this.url, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class SyncBehavior {
        public static final SyncBehavior MANUAL = new SyncBehavior(Value.MANUAL, "manual");
        public static final SyncBehavior API = new SyncBehavior(Value.API, "api");
        public static final SyncBehavior AUTOMATIC = new SyncBehavior(Value.AUTOMATIC, "automatic");
        private final Value value;
        private final String string;

        SyncBehavior(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof SyncBehavior && this.string.equals(((SyncBehavior)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case MANUAL: {
                    return visitor.visitManual();
                }
                case API: {
                    return visitor.visitApi();
                }
                case AUTOMATIC: {
                    return visitor.visitAutomatic();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static SyncBehavior valueOf(String value) {
            switch (value) {
                case "manual": {
                    return MANUAL;
                }
                case "api": {
                    return API;
                }
                case "automatic": {
                    return AUTOMATIC;
                }
            }
            return new SyncBehavior(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitApi();

            public T visitAutomatic();

            public T visitManual();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            API,
            AUTOMATIC,
            MANUAL,
            UNKNOWN;

        }
    }

    public static final class Status {
        public static final Status DEACTIVATED = new Status(Value.DEACTIVATED, "deactivated");
        public static final Status ACTIVE = new Status(Value.ACTIVE, "active");
        private final Value value;
        private final String string;

        Status(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Status && this.string.equals(((Status)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case DEACTIVATED: {
                    return visitor.visitDeactivated();
                }
                case ACTIVE: {
                    return visitor.visitActive();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Status valueOf(String value) {
            switch (value) {
                case "deactivated": {
                    return DEACTIVATED;
                }
                case "active": {
                    return ACTIVE;
                }
            }
            return new Status(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitActive();

            public T visitDeactivated();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            ACTIVE,
            DEACTIVATED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    LastSyncedAtStage,
    SyncBehaviorStage,
    StatusStage,
    UrlStage,
    CreatedAtStage,
    UpdatedAtStage,
    _FinalStage {
        private int id;
        private int lastSyncedAt;
        private SyncBehavior syncBehavior;
        private Status status;
        private String url;
        private int createdAt;
        private int updatedAt;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContentImportSource other) {
            this.id(other.getId());
            this.lastSyncedAt(other.getLastSyncedAt());
            this.syncBehavior(other.getSyncBehavior());
            this.status(other.getStatus());
            this.url(other.getUrl());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public LastSyncedAtStage id(int id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="last_synced_at")
        public SyncBehaviorStage lastSyncedAt(int lastSyncedAt) {
            this.lastSyncedAt = lastSyncedAt;
            return this;
        }

        @Override
        @JsonSetter(value="sync_behavior")
        public StatusStage syncBehavior(@NotNull SyncBehavior syncBehavior) {
            this.syncBehavior = Objects.requireNonNull(syncBehavior, "syncBehavior must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public UrlStage status(@NotNull Status status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public CreatedAtStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public ContentImportSource build() {
            return new ContentImportSource(this.id, this.lastSyncedAt, this.syncBehavior, this.status, this.url, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContentImportSource build();
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(int var1);
    }

    public static interface CreatedAtStage {
        public UpdatedAtStage createdAt(int var1);
    }

    public static interface UrlStage {
        public CreatedAtStage url(@NotNull String var1);
    }

    public static interface StatusStage {
        public UrlStage status(@NotNull Status var1);
    }

    public static interface SyncBehaviorStage {
        public StatusStage syncBehavior(@NotNull SyncBehavior var1);
    }

    public static interface LastSyncedAtStage {
        public SyncBehaviorStage lastSyncedAt(int var1);
    }

    public static interface IdStage {
        public LastSyncedAtStage id(int var1);

        public Builder from(ContentImportSource var1);
    }
}

