/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.emails;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.emails.AsyncRawEmailsClient;
import com.intercom.api.resources.unstable.emails.requests.RetrieveEmailRequest;
import com.intercom.api.resources.unstable.emails.types.EmailList;
import com.intercom.api.resources.unstable.emails.types.EmailSetting;
import java.util.concurrent.CompletableFuture;

public class AsyncEmailsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawEmailsClient rawClient;

    public AsyncEmailsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawEmailsClient(clientOptions);
    }

    public AsyncRawEmailsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<EmailList> listEmails() {
        return this.rawClient.listEmails().thenApply(response -> (EmailList)response.body());
    }

    public CompletableFuture<EmailList> listEmails(RequestOptions requestOptions) {
        return this.rawClient.listEmails(requestOptions).thenApply(response -> (EmailList)response.body());
    }

    public CompletableFuture<EmailSetting> retrieveEmail(RetrieveEmailRequest request) {
        return this.rawClient.retrieveEmail(request).thenApply(response -> (EmailSetting)response.body());
    }

    public CompletableFuture<EmailSetting> retrieveEmail(RetrieveEmailRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveEmail(request, requestOptions).thenApply(response -> (EmailSetting)response.body());
    }
}

