/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.export.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PostExportReportingDataEnqueueRequest {
    private final String datasetId;
    private final List<String> attributeIds;
    private final long startTime;
    private final long endTime;
    private final Map<String, Object> additionalProperties;

    private PostExportReportingDataEnqueueRequest(String datasetId, List<String> attributeIds, long startTime, long endTime, Map<String, Object> additionalProperties) {
        this.datasetId = datasetId;
        this.attributeIds = attributeIds;
        this.startTime = startTime;
        this.endTime = endTime;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="dataset_id")
    public String getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="attribute_ids")
    public List<String> getAttributeIds() {
        return this.attributeIds;
    }

    @JsonProperty(value="start_time")
    public long getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="end_time")
    public long getEndTime() {
        return this.endTime;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PostExportReportingDataEnqueueRequest && this.equalTo((PostExportReportingDataEnqueueRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PostExportReportingDataEnqueueRequest other) {
        return this.datasetId.equals(other.datasetId) && this.attributeIds.equals(other.attributeIds) && this.startTime == other.startTime && this.endTime == other.endTime;
    }

    public int hashCode() {
        return Objects.hash(this.datasetId, this.attributeIds, this.startTime, this.endTime);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DatasetIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DatasetIdStage,
    StartTimeStage,
    EndTimeStage,
    _FinalStage {
        private String datasetId;
        private long startTime;
        private long endTime;
        private List<String> attributeIds = new ArrayList<String>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PostExportReportingDataEnqueueRequest other) {
            this.datasetId(other.getDatasetId());
            this.attributeIds(other.getAttributeIds());
            this.startTime(other.getStartTime());
            this.endTime(other.getEndTime());
            return this;
        }

        @Override
        @JsonSetter(value="dataset_id")
        public StartTimeStage datasetId(@NotNull String datasetId) {
            this.datasetId = Objects.requireNonNull(datasetId, "datasetId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="start_time")
        public EndTimeStage startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        @JsonSetter(value="end_time")
        public _FinalStage endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public _FinalStage addAllAttributeIds(List<String> attributeIds) {
            if (attributeIds != null) {
                this.attributeIds.addAll(attributeIds);
            }
            return this;
        }

        @Override
        public _FinalStage addAttributeIds(String attributeIds) {
            this.attributeIds.add(attributeIds);
            return this;
        }

        @Override
        @JsonSetter(value="attribute_ids", nulls=Nulls.SKIP)
        public _FinalStage attributeIds(List<String> attributeIds) {
            this.attributeIds.clear();
            if (attributeIds != null) {
                this.attributeIds.addAll(attributeIds);
            }
            return this;
        }

        @Override
        public PostExportReportingDataEnqueueRequest build() {
            return new PostExportReportingDataEnqueueRequest(this.datasetId, this.attributeIds, this.startTime, this.endTime, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PostExportReportingDataEnqueueRequest build();

        public _FinalStage attributeIds(List<String> var1);

        public _FinalStage addAttributeIds(String var1);

        public _FinalStage addAllAttributeIds(List<String> var1);
    }

    public static interface EndTimeStage {
        public _FinalStage endTime(long var1);
    }

    public static interface StartTimeStage {
        public EndTimeStage startTime(long var1);
    }

    public static interface DatasetIdStage {
        public StartTimeStage datasetId(@NotNull String var1);

        public Builder from(PostExportReportingDataEnqueueRequest var1);
    }
}

