/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.companies.types.Company;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Visitor {
    private final Optional<String> type;
    private final Optional<String> id;
    private final Optional<String> userId;
    private final Optional<Boolean> anonymous;
    private final Optional<String> email;
    private final Optional<String> phone;
    private final Optional<String> name;
    private final Optional<String> pseudonym;
    private final Optional<Avatar> avatar;
    private final Optional<String> appId;
    private final Optional<Companies> companies;
    private final Optional<LocationData> locationData;
    private final Optional<Integer> lasRequestAt;
    private final Optional<Integer> createdAt;
    private final Optional<Integer> remoteCreatedAt;
    private final Optional<Integer> signedUpAt;
    private final Optional<Integer> updatedAt;
    private final Optional<Integer> sessionCount;
    private final Optional<SocialProfiles> socialProfiles;
    private final Optional<String> ownerId;
    private final Optional<Boolean> unsubscribedFromEmails;
    private final Optional<Boolean> markedEmailAsSpam;
    private final Optional<Boolean> hasHardBounced;
    private final Optional<Tags> tags;
    private final Optional<Segments> segments;
    private final Optional<Map<String, Object>> customAttributes;
    private final Optional<String> referrer;
    private final Optional<String> utmCampaign;
    private final Optional<String> utmContent;
    private final Optional<String> utmMedium;
    private final Optional<String> utmSource;
    private final Optional<String> utmTerm;
    private final Optional<Boolean> doNotTrack;
    private final Map<String, Object> additionalProperties;

    private Visitor(Optional<String> type, Optional<String> id, Optional<String> userId, Optional<Boolean> anonymous, Optional<String> email, Optional<String> phone, Optional<String> name, Optional<String> pseudonym, Optional<Avatar> avatar, Optional<String> appId, Optional<Companies> companies, Optional<LocationData> locationData, Optional<Integer> lasRequestAt, Optional<Integer> createdAt, Optional<Integer> remoteCreatedAt, Optional<Integer> signedUpAt, Optional<Integer> updatedAt, Optional<Integer> sessionCount, Optional<SocialProfiles> socialProfiles, Optional<String> ownerId, Optional<Boolean> unsubscribedFromEmails, Optional<Boolean> markedEmailAsSpam, Optional<Boolean> hasHardBounced, Optional<Tags> tags, Optional<Segments> segments, Optional<Map<String, Object>> customAttributes, Optional<String> referrer, Optional<String> utmCampaign, Optional<String> utmContent, Optional<String> utmMedium, Optional<String> utmSource, Optional<String> utmTerm, Optional<Boolean> doNotTrack, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.userId = userId;
        this.anonymous = anonymous;
        this.email = email;
        this.phone = phone;
        this.name = name;
        this.pseudonym = pseudonym;
        this.avatar = avatar;
        this.appId = appId;
        this.companies = companies;
        this.locationData = locationData;
        this.lasRequestAt = lasRequestAt;
        this.createdAt = createdAt;
        this.remoteCreatedAt = remoteCreatedAt;
        this.signedUpAt = signedUpAt;
        this.updatedAt = updatedAt;
        this.sessionCount = sessionCount;
        this.socialProfiles = socialProfiles;
        this.ownerId = ownerId;
        this.unsubscribedFromEmails = unsubscribedFromEmails;
        this.markedEmailAsSpam = markedEmailAsSpam;
        this.hasHardBounced = hasHardBounced;
        this.tags = tags;
        this.segments = segments;
        this.customAttributes = customAttributes;
        this.referrer = referrer;
        this.utmCampaign = utmCampaign;
        this.utmContent = utmContent;
        this.utmMedium = utmMedium;
        this.utmSource = utmSource;
        this.utmTerm = utmTerm;
        this.doNotTrack = doNotTrack;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="anonymous")
    public Optional<Boolean> getAnonymous() {
        return this.anonymous;
    }

    @JsonProperty(value="email")
    public Optional<String> getEmail() {
        return this.email;
    }

    @JsonProperty(value="phone")
    public Optional<String> getPhone() {
        return this.phone;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="pseudonym")
    public Optional<String> getPseudonym() {
        return this.pseudonym;
    }

    @JsonProperty(value="avatar")
    public Optional<Avatar> getAvatar() {
        return this.avatar;
    }

    @JsonProperty(value="app_id")
    public Optional<String> getAppId() {
        return this.appId;
    }

    @JsonProperty(value="companies")
    public Optional<Companies> getCompanies() {
        return this.companies;
    }

    @JsonProperty(value="location_data")
    public Optional<LocationData> getLocationData() {
        return this.locationData;
    }

    @JsonProperty(value="las_request_at")
    public Optional<Integer> getLasRequestAt() {
        return this.lasRequestAt;
    }

    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<Integer> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="signed_up_at")
    public Optional<Integer> getSignedUpAt() {
        return this.signedUpAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="session_count")
    public Optional<Integer> getSessionCount() {
        return this.sessionCount;
    }

    @JsonProperty(value="social_profiles")
    public Optional<SocialProfiles> getSocialProfiles() {
        return this.socialProfiles;
    }

    @JsonProperty(value="owner_id")
    public Optional<String> getOwnerId() {
        return this.ownerId;
    }

    @JsonProperty(value="unsubscribed_from_emails")
    public Optional<Boolean> getUnsubscribedFromEmails() {
        return this.unsubscribedFromEmails;
    }

    @JsonProperty(value="marked_email_as_spam")
    public Optional<Boolean> getMarkedEmailAsSpam() {
        return this.markedEmailAsSpam;
    }

    @JsonProperty(value="has_hard_bounced")
    public Optional<Boolean> getHasHardBounced() {
        return this.hasHardBounced;
    }

    @JsonProperty(value="tags")
    public Optional<Tags> getTags() {
        return this.tags;
    }

    @JsonProperty(value="segments")
    public Optional<Segments> getSegments() {
        return this.segments;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return this.customAttributes;
    }

    @JsonProperty(value="referrer")
    public Optional<String> getReferrer() {
        return this.referrer;
    }

    @JsonProperty(value="utm_campaign")
    public Optional<String> getUtmCampaign() {
        return this.utmCampaign;
    }

    @JsonProperty(value="utm_content")
    public Optional<String> getUtmContent() {
        return this.utmContent;
    }

    @JsonProperty(value="utm_medium")
    public Optional<String> getUtmMedium() {
        return this.utmMedium;
    }

    @JsonProperty(value="utm_source")
    public Optional<String> getUtmSource() {
        return this.utmSource;
    }

    @JsonProperty(value="utm_term")
    public Optional<String> getUtmTerm() {
        return this.utmTerm;
    }

    @JsonProperty(value="do_not_track")
    public Optional<Boolean> getDoNotTrack() {
        return this.doNotTrack;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Visitor && this.equalTo((Visitor)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Visitor other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.userId.equals(other.userId) && this.anonymous.equals(other.anonymous) && this.email.equals(other.email) && this.phone.equals(other.phone) && this.name.equals(other.name) && this.pseudonym.equals(other.pseudonym) && this.avatar.equals(other.avatar) && this.appId.equals(other.appId) && this.companies.equals(other.companies) && this.locationData.equals(other.locationData) && this.lasRequestAt.equals(other.lasRequestAt) && this.createdAt.equals(other.createdAt) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.signedUpAt.equals(other.signedUpAt) && this.updatedAt.equals(other.updatedAt) && this.sessionCount.equals(other.sessionCount) && this.socialProfiles.equals(other.socialProfiles) && this.ownerId.equals(other.ownerId) && this.unsubscribedFromEmails.equals(other.unsubscribedFromEmails) && this.markedEmailAsSpam.equals(other.markedEmailAsSpam) && this.hasHardBounced.equals(other.hasHardBounced) && this.tags.equals(other.tags) && this.segments.equals(other.segments) && this.customAttributes.equals(other.customAttributes) && this.referrer.equals(other.referrer) && this.utmCampaign.equals(other.utmCampaign) && this.utmContent.equals(other.utmContent) && this.utmMedium.equals(other.utmMedium) && this.utmSource.equals(other.utmSource) && this.utmTerm.equals(other.utmTerm) && this.doNotTrack.equals(other.doNotTrack);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.userId, this.anonymous, this.email, this.phone, this.name, this.pseudonym, this.avatar, this.appId, this.companies, this.locationData, this.lasRequestAt, this.createdAt, this.remoteCreatedAt, this.signedUpAt, this.updatedAt, this.sessionCount, this.socialProfiles, this.ownerId, this.unsubscribedFromEmails, this.markedEmailAsSpam, this.hasHardBounced, this.tags, this.segments, this.customAttributes, this.referrer, this.utmCampaign, this.utmContent, this.utmMedium, this.utmSource, this.utmTerm, this.doNotTrack);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class SocialProfiles {
        private final Optional<String> type;
        private final Optional<List<String>> socialProfiles;
        private final Map<String, Object> additionalProperties;

        private SocialProfiles(Optional<String> type, Optional<List<String>> socialProfiles, Map<String, Object> additionalProperties) {
            this.type = type;
            this.socialProfiles = socialProfiles;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="social_profiles")
        public Optional<List<String>> getSocialProfiles() {
            return this.socialProfiles;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SocialProfiles && this.equalTo((SocialProfiles)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(SocialProfiles other) {
            return this.type.equals(other.type) && this.socialProfiles.equals(other.socialProfiles);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.socialProfiles);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<List<String>> socialProfiles = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(SocialProfiles other) {
                this.type(other.getType());
                this.socialProfiles(other.getSocialProfiles());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="social_profiles", nulls=Nulls.SKIP)
            public Builder socialProfiles(Optional<List<String>> socialProfiles) {
                this.socialProfiles = socialProfiles;
                return this;
            }

            public Builder socialProfiles(List<String> socialProfiles) {
                this.socialProfiles = Optional.ofNullable(socialProfiles);
                return this;
            }

            public SocialProfiles build() {
                return new SocialProfiles(this.type, this.socialProfiles, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Tags {
        private final Optional<String> type;
        private final Optional<List<TagsItem>> tags;
        private final Map<String, Object> additionalProperties;

        private Tags(Optional<String> type, Optional<List<TagsItem>> tags, Map<String, Object> additionalProperties) {
            this.type = type;
            this.tags = tags;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="tags")
        public Optional<List<TagsItem>> getTags() {
            return this.tags;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Tags && this.equalTo((Tags)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Tags other) {
            return this.type.equals(other.type) && this.tags.equals(other.tags);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.tags);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class TagsItem {
            private final Optional<String> type;
            private final Optional<String> id;
            private final Optional<String> name;
            private final Map<String, Object> additionalProperties;

            private TagsItem(Optional<String> type, Optional<String> id, Optional<String> name, Map<String, Object> additionalProperties) {
                this.type = type;
                this.id = id;
                this.name = name;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="type")
            public Optional<String> getType() {
                return this.type;
            }

            @JsonProperty(value="id")
            public Optional<String> getId() {
                return this.id;
            }

            @JsonProperty(value="name")
            public Optional<String> getName() {
                return this.name;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof TagsItem && this.equalTo((TagsItem)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(TagsItem other) {
                return this.type.equals(other.type) && this.id.equals(other.id) && this.name.equals(other.name);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.id, this.name);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static Builder builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder {
                private Optional<String> type = Optional.empty();
                private Optional<String> id = Optional.empty();
                private Optional<String> name = Optional.empty();
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                public Builder from(TagsItem other) {
                    this.type(other.getType());
                    this.id(other.getId());
                    this.name(other.getName());
                    return this;
                }

                @JsonSetter(value="type", nulls=Nulls.SKIP)
                public Builder type(Optional<String> type) {
                    this.type = type;
                    return this;
                }

                public Builder type(String type) {
                    this.type = Optional.ofNullable(type);
                    return this;
                }

                @JsonSetter(value="id", nulls=Nulls.SKIP)
                public Builder id(Optional<String> id) {
                    this.id = id;
                    return this;
                }

                public Builder id(String id) {
                    this.id = Optional.ofNullable(id);
                    return this;
                }

                @JsonSetter(value="name", nulls=Nulls.SKIP)
                public Builder name(Optional<String> name) {
                    this.name = name;
                    return this;
                }

                public Builder name(String name) {
                    this.name = Optional.ofNullable(name);
                    return this;
                }

                public TagsItem build() {
                    return new TagsItem(this.type, this.id, this.name, this.additionalProperties);
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<List<TagsItem>> tags = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Tags other) {
                this.type(other.getType());
                this.tags(other.getTags());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="tags", nulls=Nulls.SKIP)
            public Builder tags(Optional<List<TagsItem>> tags) {
                this.tags = tags;
                return this;
            }

            public Builder tags(List<TagsItem> tags) {
                this.tags = Optional.ofNullable(tags);
                return this;
            }

            public Tags build() {
                return new Tags(this.type, this.tags, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class LocationData {
        private final Optional<String> type;
        private final Optional<String> cityName;
        private final Optional<String> continentCode;
        private final Optional<String> countryCode;
        private final Optional<String> countryName;
        private final Optional<String> postalCode;
        private final Optional<String> regionName;
        private final Optional<String> timezone;
        private final Map<String, Object> additionalProperties;

        private LocationData(Optional<String> type, Optional<String> cityName, Optional<String> continentCode, Optional<String> countryCode, Optional<String> countryName, Optional<String> postalCode, Optional<String> regionName, Optional<String> timezone, Map<String, Object> additionalProperties) {
            this.type = type;
            this.cityName = cityName;
            this.continentCode = continentCode;
            this.countryCode = countryCode;
            this.countryName = countryName;
            this.postalCode = postalCode;
            this.regionName = regionName;
            this.timezone = timezone;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="city_name")
        public Optional<String> getCityName() {
            return this.cityName;
        }

        @JsonProperty(value="continent_code")
        public Optional<String> getContinentCode() {
            return this.continentCode;
        }

        @JsonProperty(value="country_code")
        public Optional<String> getCountryCode() {
            return this.countryCode;
        }

        @JsonProperty(value="country_name")
        public Optional<String> getCountryName() {
            return this.countryName;
        }

        @JsonProperty(value="postal_code")
        public Optional<String> getPostalCode() {
            return this.postalCode;
        }

        @JsonProperty(value="region_name")
        public Optional<String> getRegionName() {
            return this.regionName;
        }

        @JsonProperty(value="timezone")
        public Optional<String> getTimezone() {
            return this.timezone;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof LocationData && this.equalTo((LocationData)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(LocationData other) {
            return this.type.equals(other.type) && this.cityName.equals(other.cityName) && this.continentCode.equals(other.continentCode) && this.countryCode.equals(other.countryCode) && this.countryName.equals(other.countryName) && this.postalCode.equals(other.postalCode) && this.regionName.equals(other.regionName) && this.timezone.equals(other.timezone);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.cityName, this.continentCode, this.countryCode, this.countryName, this.postalCode, this.regionName, this.timezone);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<String> cityName = Optional.empty();
            private Optional<String> continentCode = Optional.empty();
            private Optional<String> countryCode = Optional.empty();
            private Optional<String> countryName = Optional.empty();
            private Optional<String> postalCode = Optional.empty();
            private Optional<String> regionName = Optional.empty();
            private Optional<String> timezone = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(LocationData other) {
                this.type(other.getType());
                this.cityName(other.getCityName());
                this.continentCode(other.getContinentCode());
                this.countryCode(other.getCountryCode());
                this.countryName(other.getCountryName());
                this.postalCode(other.getPostalCode());
                this.regionName(other.getRegionName());
                this.timezone(other.getTimezone());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="city_name", nulls=Nulls.SKIP)
            public Builder cityName(Optional<String> cityName) {
                this.cityName = cityName;
                return this;
            }

            public Builder cityName(String cityName) {
                this.cityName = Optional.ofNullable(cityName);
                return this;
            }

            @JsonSetter(value="continent_code", nulls=Nulls.SKIP)
            public Builder continentCode(Optional<String> continentCode) {
                this.continentCode = continentCode;
                return this;
            }

            public Builder continentCode(String continentCode) {
                this.continentCode = Optional.ofNullable(continentCode);
                return this;
            }

            @JsonSetter(value="country_code", nulls=Nulls.SKIP)
            public Builder countryCode(Optional<String> countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public Builder countryCode(String countryCode) {
                this.countryCode = Optional.ofNullable(countryCode);
                return this;
            }

            @JsonSetter(value="country_name", nulls=Nulls.SKIP)
            public Builder countryName(Optional<String> countryName) {
                this.countryName = countryName;
                return this;
            }

            public Builder countryName(String countryName) {
                this.countryName = Optional.ofNullable(countryName);
                return this;
            }

            @JsonSetter(value="postal_code", nulls=Nulls.SKIP)
            public Builder postalCode(Optional<String> postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            public Builder postalCode(String postalCode) {
                this.postalCode = Optional.ofNullable(postalCode);
                return this;
            }

            @JsonSetter(value="region_name", nulls=Nulls.SKIP)
            public Builder regionName(Optional<String> regionName) {
                this.regionName = regionName;
                return this;
            }

            public Builder regionName(String regionName) {
                this.regionName = Optional.ofNullable(regionName);
                return this;
            }

            @JsonSetter(value="timezone", nulls=Nulls.SKIP)
            public Builder timezone(Optional<String> timezone) {
                this.timezone = timezone;
                return this;
            }

            public Builder timezone(String timezone) {
                this.timezone = Optional.ofNullable(timezone);
                return this;
            }

            public LocationData build() {
                return new LocationData(this.type, this.cityName, this.continentCode, this.countryCode, this.countryName, this.postalCode, this.regionName, this.timezone, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Segments {
        private final Optional<String> type;
        private final Optional<List<String>> segments;
        private final Map<String, Object> additionalProperties;

        private Segments(Optional<String> type, Optional<List<String>> segments, Map<String, Object> additionalProperties) {
            this.type = type;
            this.segments = segments;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="segments")
        public Optional<List<String>> getSegments() {
            return this.segments;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Segments && this.equalTo((Segments)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Segments other) {
            return this.type.equals(other.type) && this.segments.equals(other.segments);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.segments);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<List<String>> segments = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Segments other) {
                this.type(other.getType());
                this.segments(other.getSegments());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="segments", nulls=Nulls.SKIP)
            public Builder segments(Optional<List<String>> segments) {
                this.segments = segments;
                return this;
            }

            public Builder segments(List<String> segments) {
                this.segments = Optional.ofNullable(segments);
                return this;
            }

            public Segments build() {
                return new Segments(this.type, this.segments, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Companies {
        private final Optional<String> type;
        private final Optional<List<Company>> companies;
        private final Map<String, Object> additionalProperties;

        private Companies(Optional<String> type, Optional<List<Company>> companies, Map<String, Object> additionalProperties) {
            this.type = type;
            this.companies = companies;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="companies")
        public Optional<List<Company>> getCompanies() {
            return this.companies;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Companies && this.equalTo((Companies)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Companies other) {
            return this.type.equals(other.type) && this.companies.equals(other.companies);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.companies);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<List<Company>> companies = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Companies other) {
                this.type(other.getType());
                this.companies(other.getCompanies());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="companies", nulls=Nulls.SKIP)
            public Builder companies(Optional<List<Company>> companies) {
                this.companies = companies;
                return this;
            }

            public Builder companies(List<Company> companies) {
                this.companies = Optional.ofNullable(companies);
                return this;
            }

            public Companies build() {
                return new Companies(this.type, this.companies, this.additionalProperties);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Avatar {
        private final Optional<String> type;
        private final Optional<String> imageUrl;
        private final Map<String, Object> additionalProperties;

        private Avatar(Optional<String> type, Optional<String> imageUrl, Map<String, Object> additionalProperties) {
            this.type = type;
            this.imageUrl = imageUrl;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="image_url")
        public Optional<String> getImageUrl() {
            return this.imageUrl;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Avatar && this.equalTo((Avatar)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Avatar other) {
            return this.type.equals(other.type) && this.imageUrl.equals(other.imageUrl);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.imageUrl);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<String> imageUrl = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Avatar other) {
                this.type(other.getType());
                this.imageUrl(other.getImageUrl());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="image_url", nulls=Nulls.SKIP)
            public Builder imageUrl(Optional<String> imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            public Builder imageUrl(String imageUrl) {
                this.imageUrl = Optional.ofNullable(imageUrl);
                return this;
            }

            public Avatar build() {
                return new Avatar(this.type, this.imageUrl, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private Optional<Boolean> anonymous = Optional.empty();
        private Optional<String> email = Optional.empty();
        private Optional<String> phone = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> pseudonym = Optional.empty();
        private Optional<Avatar> avatar = Optional.empty();
        private Optional<String> appId = Optional.empty();
        private Optional<Companies> companies = Optional.empty();
        private Optional<LocationData> locationData = Optional.empty();
        private Optional<Integer> lasRequestAt = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        private Optional<Integer> remoteCreatedAt = Optional.empty();
        private Optional<Integer> signedUpAt = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<Integer> sessionCount = Optional.empty();
        private Optional<SocialProfiles> socialProfiles = Optional.empty();
        private Optional<String> ownerId = Optional.empty();
        private Optional<Boolean> unsubscribedFromEmails = Optional.empty();
        private Optional<Boolean> markedEmailAsSpam = Optional.empty();
        private Optional<Boolean> hasHardBounced = Optional.empty();
        private Optional<Tags> tags = Optional.empty();
        private Optional<Segments> segments = Optional.empty();
        private Optional<Map<String, Object>> customAttributes = Optional.empty();
        private Optional<String> referrer = Optional.empty();
        private Optional<String> utmCampaign = Optional.empty();
        private Optional<String> utmContent = Optional.empty();
        private Optional<String> utmMedium = Optional.empty();
        private Optional<String> utmSource = Optional.empty();
        private Optional<String> utmTerm = Optional.empty();
        private Optional<Boolean> doNotTrack = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Visitor other) {
            this.type(other.getType());
            this.id(other.getId());
            this.userId(other.getUserId());
            this.anonymous(other.getAnonymous());
            this.email(other.getEmail());
            this.phone(other.getPhone());
            this.name(other.getName());
            this.pseudonym(other.getPseudonym());
            this.avatar(other.getAvatar());
            this.appId(other.getAppId());
            this.companies(other.getCompanies());
            this.locationData(other.getLocationData());
            this.lasRequestAt(other.getLasRequestAt());
            this.createdAt(other.getCreatedAt());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.signedUpAt(other.getSignedUpAt());
            this.updatedAt(other.getUpdatedAt());
            this.sessionCount(other.getSessionCount());
            this.socialProfiles(other.getSocialProfiles());
            this.ownerId(other.getOwnerId());
            this.unsubscribedFromEmails(other.getUnsubscribedFromEmails());
            this.markedEmailAsSpam(other.getMarkedEmailAsSpam());
            this.hasHardBounced(other.getHasHardBounced());
            this.tags(other.getTags());
            this.segments(other.getSegments());
            this.customAttributes(other.getCustomAttributes());
            this.referrer(other.getReferrer());
            this.utmCampaign(other.getUtmCampaign());
            this.utmContent(other.getUtmContent());
            this.utmMedium(other.getUtmMedium());
            this.utmSource(other.getUtmSource());
            this.utmTerm(other.getUtmTerm());
            this.doNotTrack(other.getDoNotTrack());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @JsonSetter(value="anonymous", nulls=Nulls.SKIP)
        public Builder anonymous(Optional<Boolean> anonymous) {
            this.anonymous = anonymous;
            return this;
        }

        public Builder anonymous(Boolean anonymous) {
            this.anonymous = Optional.ofNullable(anonymous);
            return this;
        }

        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public Builder email(Optional<String> email) {
            this.email = email;
            return this;
        }

        public Builder email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        @JsonSetter(value="phone", nulls=Nulls.SKIP)
        public Builder phone(Optional<String> phone) {
            this.phone = phone;
            return this;
        }

        public Builder phone(String phone) {
            this.phone = Optional.ofNullable(phone);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="pseudonym", nulls=Nulls.SKIP)
        public Builder pseudonym(Optional<String> pseudonym) {
            this.pseudonym = pseudonym;
            return this;
        }

        public Builder pseudonym(String pseudonym) {
            this.pseudonym = Optional.ofNullable(pseudonym);
            return this;
        }

        @JsonSetter(value="avatar", nulls=Nulls.SKIP)
        public Builder avatar(Optional<Avatar> avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder avatar(Avatar avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        @JsonSetter(value="app_id", nulls=Nulls.SKIP)
        public Builder appId(Optional<String> appId) {
            this.appId = appId;
            return this;
        }

        public Builder appId(String appId) {
            this.appId = Optional.ofNullable(appId);
            return this;
        }

        @JsonSetter(value="companies", nulls=Nulls.SKIP)
        public Builder companies(Optional<Companies> companies) {
            this.companies = companies;
            return this;
        }

        public Builder companies(Companies companies) {
            this.companies = Optional.ofNullable(companies);
            return this;
        }

        @JsonSetter(value="location_data", nulls=Nulls.SKIP)
        public Builder locationData(Optional<LocationData> locationData) {
            this.locationData = locationData;
            return this;
        }

        public Builder locationData(LocationData locationData) {
            this.locationData = Optional.ofNullable(locationData);
            return this;
        }

        @JsonSetter(value="las_request_at", nulls=Nulls.SKIP)
        public Builder lasRequestAt(Optional<Integer> lasRequestAt) {
            this.lasRequestAt = lasRequestAt;
            return this;
        }

        public Builder lasRequestAt(Integer lasRequestAt) {
            this.lasRequestAt = Optional.ofNullable(lasRequestAt);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<Integer> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(Integer remoteCreatedAt) {
            this.remoteCreatedAt = Optional.ofNullable(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="signed_up_at", nulls=Nulls.SKIP)
        public Builder signedUpAt(Optional<Integer> signedUpAt) {
            this.signedUpAt = signedUpAt;
            return this;
        }

        public Builder signedUpAt(Integer signedUpAt) {
            this.signedUpAt = Optional.ofNullable(signedUpAt);
            return this;
        }

        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @JsonSetter(value="session_count", nulls=Nulls.SKIP)
        public Builder sessionCount(Optional<Integer> sessionCount) {
            this.sessionCount = sessionCount;
            return this;
        }

        public Builder sessionCount(Integer sessionCount) {
            this.sessionCount = Optional.ofNullable(sessionCount);
            return this;
        }

        @JsonSetter(value="social_profiles", nulls=Nulls.SKIP)
        public Builder socialProfiles(Optional<SocialProfiles> socialProfiles) {
            this.socialProfiles = socialProfiles;
            return this;
        }

        public Builder socialProfiles(SocialProfiles socialProfiles) {
            this.socialProfiles = Optional.ofNullable(socialProfiles);
            return this;
        }

        @JsonSetter(value="owner_id", nulls=Nulls.SKIP)
        public Builder ownerId(Optional<String> ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder ownerId(String ownerId) {
            this.ownerId = Optional.ofNullable(ownerId);
            return this;
        }

        @JsonSetter(value="unsubscribed_from_emails", nulls=Nulls.SKIP)
        public Builder unsubscribedFromEmails(Optional<Boolean> unsubscribedFromEmails) {
            this.unsubscribedFromEmails = unsubscribedFromEmails;
            return this;
        }

        public Builder unsubscribedFromEmails(Boolean unsubscribedFromEmails) {
            this.unsubscribedFromEmails = Optional.ofNullable(unsubscribedFromEmails);
            return this;
        }

        @JsonSetter(value="marked_email_as_spam", nulls=Nulls.SKIP)
        public Builder markedEmailAsSpam(Optional<Boolean> markedEmailAsSpam) {
            this.markedEmailAsSpam = markedEmailAsSpam;
            return this;
        }

        public Builder markedEmailAsSpam(Boolean markedEmailAsSpam) {
            this.markedEmailAsSpam = Optional.ofNullable(markedEmailAsSpam);
            return this;
        }

        @JsonSetter(value="has_hard_bounced", nulls=Nulls.SKIP)
        public Builder hasHardBounced(Optional<Boolean> hasHardBounced) {
            this.hasHardBounced = hasHardBounced;
            return this;
        }

        public Builder hasHardBounced(Boolean hasHardBounced) {
            this.hasHardBounced = Optional.ofNullable(hasHardBounced);
            return this;
        }

        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public Builder tags(Optional<Tags> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(Tags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @JsonSetter(value="segments", nulls=Nulls.SKIP)
        public Builder segments(Optional<Segments> segments) {
            this.segments = segments;
            return this;
        }

        public Builder segments(Segments segments) {
            this.segments = Optional.ofNullable(segments);
            return this;
        }

        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public Builder customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public Builder customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @JsonSetter(value="referrer", nulls=Nulls.SKIP)
        public Builder referrer(Optional<String> referrer) {
            this.referrer = referrer;
            return this;
        }

        public Builder referrer(String referrer) {
            this.referrer = Optional.ofNullable(referrer);
            return this;
        }

        @JsonSetter(value="utm_campaign", nulls=Nulls.SKIP)
        public Builder utmCampaign(Optional<String> utmCampaign) {
            this.utmCampaign = utmCampaign;
            return this;
        }

        public Builder utmCampaign(String utmCampaign) {
            this.utmCampaign = Optional.ofNullable(utmCampaign);
            return this;
        }

        @JsonSetter(value="utm_content", nulls=Nulls.SKIP)
        public Builder utmContent(Optional<String> utmContent) {
            this.utmContent = utmContent;
            return this;
        }

        public Builder utmContent(String utmContent) {
            this.utmContent = Optional.ofNullable(utmContent);
            return this;
        }

        @JsonSetter(value="utm_medium", nulls=Nulls.SKIP)
        public Builder utmMedium(Optional<String> utmMedium) {
            this.utmMedium = utmMedium;
            return this;
        }

        public Builder utmMedium(String utmMedium) {
            this.utmMedium = Optional.ofNullable(utmMedium);
            return this;
        }

        @JsonSetter(value="utm_source", nulls=Nulls.SKIP)
        public Builder utmSource(Optional<String> utmSource) {
            this.utmSource = utmSource;
            return this;
        }

        public Builder utmSource(String utmSource) {
            this.utmSource = Optional.ofNullable(utmSource);
            return this;
        }

        @JsonSetter(value="utm_term", nulls=Nulls.SKIP)
        public Builder utmTerm(Optional<String> utmTerm) {
            this.utmTerm = utmTerm;
            return this;
        }

        public Builder utmTerm(String utmTerm) {
            this.utmTerm = Optional.ofNullable(utmTerm);
            return this;
        }

        @JsonSetter(value="do_not_track", nulls=Nulls.SKIP)
        public Builder doNotTrack(Optional<Boolean> doNotTrack) {
            this.doNotTrack = doNotTrack;
            return this;
        }

        public Builder doNotTrack(Boolean doNotTrack) {
            this.doNotTrack = Optional.ofNullable(doNotTrack);
            return this;
        }

        public Visitor build() {
            return new Visitor(this.type, this.id, this.userId, this.anonymous, this.email, this.phone, this.name, this.pseudonym, this.avatar, this.appId, this.companies, this.locationData, this.lasRequestAt, this.createdAt, this.remoteCreatedAt, this.signedUpAt, this.updatedAt, this.sessionCount, this.socialProfiles, this.ownerId, this.unsubscribedFromEmails, this.markedEmailAsSpam, this.hasHardBounced, this.tags, this.segments, this.customAttributes, this.referrer, this.utmCampaign, this.utmContent, this.utmMedium, this.utmSource, this.utmTerm, this.doNotTrack, this.additionalProperties);
        }
    }
}

